@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultValue The default value of the parameter.
 * @property description The description of parameter.
 * @property in Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
 * @property inService Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
 * @property name Request's parameter name.
 * @property nameService Backend service's parameter name.
 * @property required Parameter required or not; values: REQUIRED and OPTIONAL.
 * @property type Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
 */
public data class ApiRequestParameter(
    public val defaultValue: String? = null,
    public val description: String? = null,
    public val `in`: String,
    public val inService: String,
    public val name: String,
    public val nameService: String,
    public val required: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.ApiRequestParameter): ApiRequestParameter = ApiRequestParameter(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            `in` = javaType.`in`(),
            inService = javaType.inService(),
            name = javaType.name(),
            nameService = javaType.nameService(),
            required = javaType.required(),
            type = javaType.type(),
        )
    }
}
