@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiId The ID of the API.
 * @property description The description of the API.
 * @property groupId The ID of the API group.
 * @property groupName The name of the API group.
 * @property id
 * @property name The name of the API.
 * @property regionId The region ID of the API.
 */
public data class GetApisApi(
    public val apiId: String,
    public val description: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val name: String,
    public val regionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetApisApi): GetApisApi =
            GetApisApi(
                apiId = javaType.apiId(),
                description = javaType.description(),
                groupId = javaType.groupId(),
                groupName = javaType.groupName(),
                id = javaType.id(),
                name = javaType.name(),
                regionId = javaType.regionId(),
            )
    }
}
