@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApis.
 * @property apiId (Available since v1.224.0) The ID of the API.
 * @property apis A list of APIs. Each element contains the following attributes:
 * @property groupId The ID of the API group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of API names.
 * @property outputFile
 */
public data class GetApisResult(
    public val apiId: String? = null,
    public val apis: List<GetApisApi>,
    public val groupId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetApisResult): GetApisResult = GetApisResult(
            apiId = javaType.apiId().map({ args0 -> args0 }).orElse(null),
            apis = javaType.apis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.apigateway.kotlin.outputs.GetApisApi.Companion.toKotlin(args0)
                })
            }),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
