@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appCode App code.
 * @property createdTime Creation time (Greenwich mean time).
 * @property description App description.
 * @property id App ID, which is generated by the system and globally unique.
 * @property modifiedTime Last modification time (Greenwich mean time).
 * @property name App name.
 */
public data class GetAppsApp(
    public val appCode: String,
    public val createdTime: String,
    public val description: String,
    public val id: Int,
    public val modifiedTime: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetAppsApp): GetAppsApp =
            GetAppsApp(
                appCode = javaType.appCode(),
                createdTime = javaType.createdTime(),
                description = javaType.description(),
                id = javaType.id(),
                modifiedTime = javaType.modifiedTime(),
                name = javaType.name(),
            )
    }
}
