@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backendId The id of the Backend.
 * @property backendName The name of the Backend.
 * @property backendType The type of the Backend.
 * @property createTime The created time of the Backend.
 * @property description The description of the Backend.
 * @property id
 * @property modifiedTime The modified time of the Backend.
 */
public data class GetBackendsBackend(
    public val backendId: String,
    public val backendName: String,
    public val backendType: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val modifiedTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetBackendsBackend): GetBackendsBackend = GetBackendsBackend(
            backendId = javaType.backendId(),
            backendName = javaType.backendName(),
            backendType = javaType.backendType(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            modifiedTime = javaType.modifiedTime(),
        )
    }
}
