@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property billingStatus Billing status.
 * - NORMAL: The API group is normal.
 * - LOCKED: Locked due to outstanding payment.
 * @property createdTime Creation time (Greenwich mean time).
 * @property description API group description.
 * @property id API group ID, which is generated by the system and globally unique.
 * @property illegalStatus Locking in invalid state.
 * - NORMAL: The API group is normal.
 * - LOCKED: Locked due to illegality.
 * @property modifiedTime Last modification time (Greenwich mean time).
 * @property name API group name.
 * @property regionId The ID of the region where the API group is located.
 * @property subDomain Second-level domain name automatically assigned to the API group.
 * @property trafficLimit Upper QPS limit of the API group; default value: 500, which can be increased by submitting an application.
 */
public data class GetGroupsGroup(
    public val billingStatus: String,
    public val createdTime: String,
    public val description: String,
    public val id: String,
    public val illegalStatus: String,
    public val modifiedTime: String,
    public val name: String,
    public val regionId: String,
    public val subDomain: String,
    public val trafficLimit: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetGroupsGroup): GetGroupsGroup = GetGroupsGroup(
            billingStatus = javaType.billingStatus(),
            createdTime = javaType.createdTime(),
            description = javaType.description(),
            id = javaType.id(),
            illegalStatus = javaType.illegalStatus(),
            modifiedTime = javaType.modifiedTime(),
            name = javaType.name(),
            regionId = javaType.regionId(),
            subDomain = javaType.subDomain(),
            trafficLimit = javaType.trafficLimit(),
        )
    }
}
