@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Log Config.
 * @property logType The type the of log.
 * @property regionId The region ID of the Log Config.
 * @property slsLogStore The name of the Log Store.
 * @property slsProject The name of the Project.
 */
public data class GetLogConfigsConfig(
    public val id: String,
    public val logType: String,
    public val regionId: String,
    public val slsLogStore: String,
    public val slsProject: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetLogConfigsConfig): GetLogConfigsConfig = GetLogConfigsConfig(
            id = javaType.id(),
            logType = javaType.logType(),
            regionId = javaType.regionId(),
            slsLogStore = javaType.slsLogStore(),
            slsProject = javaType.slsProject(),
        )
    }
}
