@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLogConfigs.
 * @property configs
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property logType
 * @property outputFile
 */
public data class GetLogConfigsResult(
    public val configs: List<GetLogConfigsConfig>,
    public val id: String,
    public val ids: List<String>,
    public val logType: String? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetLogConfigsResult): GetLogConfigsResult = GetLogConfigsResult(
            configs = javaType.configs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.apigateway.kotlin.outputs.GetLogConfigsConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            logType = javaType.logType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
