@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the model.
 * @property description The description of the model.
 * @property groupId The ID of the api group.
 * @property id The ID of the Api Gateway Model.
 * @property modelId The id of the model.
 * @property modelName The name of the Model.
 * @property modelRef The reference of the model.
 * @property modifiedTime The modified time of the model.
 * @property schema The schema of the model.
 */
public data class GetModelsModel(
    public val createTime: String,
    public val description: String,
    public val groupId: String,
    public val id: String,
    public val modelId: String,
    public val modelName: String,
    public val modelRef: String,
    public val modifiedTime: String,
    public val schema: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetModelsModel): GetModelsModel = GetModelsModel(
            createTime = javaType.createTime(),
            description = javaType.description(),
            groupId = javaType.groupId(),
            id = javaType.id(),
            modelId = javaType.modelId(),
            modelName = javaType.modelName(),
            modelRef = javaType.modelRef(),
            modifiedTime = javaType.modifiedTime(),
            schema = javaType.schema(),
        )
    }
}
