@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getModels.
 * @property groupId The group of the model belongs to.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property modelName The name of the Model.
 * @property models A list of Api Gateway Models. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of Model names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetModelsResult(
    public val groupId: String,
    public val id: String,
    public val ids: List<String>,
    public val modelName: String? = null,
    public val models: List<GetModelsModel>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetModelsResult): GetModelsResult = GetModelsResult(
            groupId = javaType.groupId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            modelName = javaType.modelName().map({ args0 -> args0 }).orElse(null),
            models = javaType.models().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.apigateway.kotlin.outputs.GetModelsModel.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
