@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property createTime The CreateTime of the resource.
 * @property description The description of the plug-in, which cannot exceed 200 characters.
 * @property id The ID of the Plugin.
 * @property modifiedTime The ModifiedTime of the resource.
 * @property pluginData The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
 * @property pluginId The first ID of the resource.
 * @property pluginName The name of the plug-in that you want to create.
 * @property pluginType The type of the plug-in.
 * @property tags The tag of the resource.
 */
public data class GetPluginsPlugin(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val modifiedTime: String,
    public val pluginData: String,
    public val pluginId: String,
    public val pluginName: String,
    public val pluginType: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetPluginsPlugin): GetPluginsPlugin = GetPluginsPlugin(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            modifiedTime = javaType.modifiedTime(),
            pluginData = javaType.pluginData(),
            pluginId = javaType.pluginId(),
            pluginName = javaType.pluginName(),
            pluginType = javaType.pluginType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
