@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getPlugins.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property pluginName
 * @property pluginType
 * @property plugins
 * @property tags
 */
public data class GetPluginsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val pluginName: String? = null,
    public val pluginType: String? = null,
    public val plugins: List<GetPluginsPlugin>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.GetPluginsResult): GetPluginsResult = GetPluginsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            pluginName = javaType.pluginName().map({ args0 -> args0 }).orElse(null),
            pluginType = javaType.pluginType().map({ args0 -> args0 }).orElse(null),
            plugins = javaType.plugins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.apigateway.kotlin.outputs.GetPluginsPlugin.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
