@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The CIDR block of the VSwitch.
 * @property customized Specifies whether the IP block is customized.
 * @property vswitchId The VSwitch ID.
 * @property zoneId The zone ID.
 */
public data class InstanceToConnectVpcIpBlock(
    public val cidrBlock: String,
    public val customized: Boolean? = null,
    public val vswitchId: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.InstanceToConnectVpcIpBlock): InstanceToConnectVpcIpBlock = InstanceToConnectVpcIpBlock(
            cidrBlock = javaType.cidrBlock(),
            customized = javaType.customized().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
