@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The CIDR block of the VSwitch.
 * @property securityGroup The ID of the security group.
 * @property vswitchId The VSwitch ID.
 * @property zoneId The zone ID.
 */
public data class InstanceZoneVswitchSecurityGroup(
    public val cidrBlock: String,
    public val securityGroup: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.InstanceZoneVswitchSecurityGroup): InstanceZoneVswitchSecurityGroup = InstanceZoneVswitchSecurityGroup(
            cidrBlock = javaType.cidrBlock(),
            securityGroup = javaType.securityGroup(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
