@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AddonRelease].
 */
@PulumiTagMarker
public class AddonReleaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AddonReleaseArgs = AddonReleaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AddonReleaseArgsBuilder.() -> Unit) {
        val builder = AddonReleaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AddonRelease {
        val builtJavaResource = com.pulumi.alicloud.arms.AddonRelease(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AddonRelease(builtJavaResource)
    }
}

/**
 * Provides a ARMS Addon Release resource. Release package of observability addon.
 * For information about ARMS Addon Release and how to use it, see [What is Addon Release](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installaddon).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Addon Release can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/addonRelease:AddonRelease example <environment_id>:<addon_release_name>
 * ```
 */
public class AddonRelease internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.AddonRelease,
) : KotlinCustomResource(javaResource, AddonReleaseMapper) {
    /**
     * Addon Name.
     */
    public val addonName: Output<String>
        get() = javaResource.addonName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val addonReleaseName: Output<String>
        get() = javaResource.addonReleaseName().applyValue({ args0 -> args0 })

    /**
     * Version number of Addon. Addon information can be obtained through ListAddons.
     */
    public val addonVersion: Output<String>
        get() = javaResource.addonVersion().applyValue({ args0 -> args0 })

    /**
     * The installed locale.
     */
    public val aliyunLang: Output<String>
        get() = javaResource.aliyunLang().applyValue({ args0 -> args0 })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Environment id.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
     */
    public val values: Output<String>?
        get() = javaResource.values().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AddonReleaseMapper : ResourceMapper<AddonRelease> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.AddonRelease::class == javaResource::class

    override fun map(javaResource: Resource): AddonRelease = AddonRelease(
        javaResource as
            com.pulumi.alicloud.arms.AddonRelease,
    )
}

/**
 * @see [AddonRelease].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AddonRelease].
 */
public suspend fun addonRelease(
    name: String,
    block: suspend AddonReleaseResourceBuilder.() -> Unit,
): AddonRelease {
    val builder = AddonReleaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AddonRelease].
 * @param name The _unique_ name of the resulting resource.
 */
public fun addonRelease(name: String): AddonRelease {
    val builder = AddonReleaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
