@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.AddonReleaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Addon Release resource. Release package of observability addon.
 * For information about ARMS Addon Release and how to use it, see [What is Addon Release](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installaddon).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Addon Release can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/addonRelease:AddonRelease example <environment_id>:<addon_release_name>
 * ```
 * @property addonName Addon Name.
 * @property addonReleaseName The name of the resource.
 * @property addonVersion Version number of Addon. Addon information can be obtained through ListAddons.
 * @property aliyunLang The installed locale.
 * @property environmentId Environment id.
 * @property values Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
 */
public data class AddonReleaseArgs(
    public val addonName: Output<String>? = null,
    public val addonReleaseName: Output<String>? = null,
    public val addonVersion: Output<String>? = null,
    public val aliyunLang: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val values: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.AddonReleaseArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.AddonReleaseArgs =
        com.pulumi.alicloud.arms.AddonReleaseArgs.builder()
            .addonName(addonName?.applyValue({ args0 -> args0 }))
            .addonReleaseName(addonReleaseName?.applyValue({ args0 -> args0 }))
            .addonVersion(addonVersion?.applyValue({ args0 -> args0 }))
            .aliyunLang(aliyunLang?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonReleaseArgs].
 */
@PulumiTagMarker
public class AddonReleaseArgsBuilder internal constructor() {
    private var addonName: Output<String>? = null

    private var addonReleaseName: Output<String>? = null

    private var addonVersion: Output<String>? = null

    private var aliyunLang: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var values: Output<String>? = null

    /**
     * @param value Addon Name.
     */
    @JvmName("xdmmguwtsrwaasqg")
    public suspend fun addonName(`value`: Output<String>) {
        this.addonName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("obqqpvrghqficfdi")
    public suspend fun addonReleaseName(`value`: Output<String>) {
        this.addonReleaseName = value
    }

    /**
     * @param value Version number of Addon. Addon information can be obtained through ListAddons.
     */
    @JvmName("pgcmdhsqaekbbhxh")
    public suspend fun addonVersion(`value`: Output<String>) {
        this.addonVersion = value
    }

    /**
     * @param value The installed locale.
     */
    @JvmName("daprdawbmlhaewal")
    public suspend fun aliyunLang(`value`: Output<String>) {
        this.aliyunLang = value
    }

    /**
     * @param value Environment id.
     */
    @JvmName("hnpdpivjsktstcqx")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
     */
    @JvmName("gysvmxoxarfkauqg")
    public suspend fun values(`value`: Output<String>) {
        this.values = value
    }

    /**
     * @param value Addon Name.
     */
    @JvmName("mjqlmkscgpxhxbyl")
    public suspend fun addonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("pihwtjyalebdklxd")
    public suspend fun addonReleaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonReleaseName = mapped
    }

    /**
     * @param value Version number of Addon. Addon information can be obtained through ListAddons.
     */
    @JvmName("ufxyuwhcdnjwxrtu")
    public suspend fun addonVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonVersion = mapped
    }

    /**
     * @param value The installed locale.
     */
    @JvmName("gnkcteswpagrphur")
    public suspend fun aliyunLang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliyunLang = mapped
    }

    /**
     * @param value Environment id.
     */
    @JvmName("flujxpqjxvcpqoks")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
     */
    @JvmName("xhyqhoxbktpwjnlg")
    public suspend fun values(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): AddonReleaseArgs = AddonReleaseArgs(
        addonName = addonName,
        addonReleaseName = addonReleaseName,
        addonVersion = addonVersion,
        aliyunLang = aliyunLang,
        environmentId = environmentId,
        values = values,
    )
}
