@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlertContact].
 */
@PulumiTagMarker
public class AlertContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertContactArgs = AlertContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertContactArgsBuilder.() -> Unit) {
        val builder = AlertContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlertContact {
        val builtJavaResource = com.pulumi.alicloud.arms.AlertContact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlertContact(builtJavaResource)
    }
}

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Alert Contact resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Alert Contact and how to use it, see [What is Alert Contact](https://www.alibabacloud.com/help/en/application-real-time-monitoring-service/latest/createalertcontact).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.arms.AlertContact("example", {
 *     alertContactName: "example_value",
 *     dingRobotWebhookUrl: "https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *     email: "someone@example.com",
 *     phoneNum: "1381111****",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.arms.AlertContact("example",
 *     alert_contact_name="example_value",
 *     ding_robot_webhook_url="https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *     email="someone@example.com",
 *     phone_num="1381111****")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Arms.AlertContact("example", new()
 *     {
 *         AlertContactName = "example_value",
 *         DingRobotWebhookUrl = "https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *         Email = "someone@example.com",
 *         PhoneNum = "1381111****",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := arms.NewAlertContact(ctx, "example", &arms.AlertContactArgs{
 * 			AlertContactName:    pulumi.String("example_value"),
 * 			DingRobotWebhookUrl: pulumi.String("https://oapi.dingtalk.com/robot/send?access_token=91f2f6****"),
 * 			Email:               pulumi.String("someone@example.com"),
 * 			PhoneNum:            pulumi.String("1381111****"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.arms.AlertContact;
 * import com.pulumi.alicloud.arms.AlertContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlertContact("example", AlertContactArgs.builder()
 *             .alertContactName("example_value")
 *             .dingRobotWebhookUrl("https://oapi.dingtalk.com/robot/send?access_token=91f2f6****")
 *             .email("someone@example.com")
 *             .phoneNum("1381111****")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:arms:AlertContact
 *     properties:
 *       alertContactName: example_value
 *       dingRobotWebhookUrl: https://oapi.dingtalk.com/robot/send?access_token=91f2f6****
 *       email: someone@example.com
 *       phoneNum: 1381111****
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Alert Contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/alertContact:AlertContact example <id>
 * ```
 */
public class AlertContact internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.AlertContact,
) : KotlinCustomResource(javaResource, AlertContactMapper) {
    /**
     * The name of the alert contact.
     */
    public val alertContactName: Output<String>?
        get() = javaResource.alertContactName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The webhook URL of the DingTalk chatbot. For more information about how to obtain the URL, see Configure a DingTalk chatbot to send alert notifications: https://www.alibabacloud.com/help/en/doc-detail/106247.htm. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    public val dingRobotWebhookUrl: Output<String>?
        get() = javaResource.dingRobotWebhookUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email address of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    public val email: Output<String>?
        get() = javaResource.email().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The mobile number of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    public val phoneNum: Output<String>?
        get() = javaResource.phoneNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether the alert contact receives system notifications. Valid values:  true: receives system notifications. false: does not receive system notifications.
     */
    public val systemNoc: Output<Boolean>?
        get() = javaResource.systemNoc().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AlertContactMapper : ResourceMapper<AlertContact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.AlertContact::class == javaResource::class

    override fun map(javaResource: Resource): AlertContact = AlertContact(
        javaResource as
            com.pulumi.alicloud.arms.AlertContact,
    )
}

/**
 * @see [AlertContact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlertContact].
 */
public suspend fun alertContact(
    name: String,
    block: suspend AlertContactResourceBuilder.() -> Unit,
): AlertContact {
    val builder = AlertContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlertContact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alertContact(name: String): AlertContact {
    val builder = AlertContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
