@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.AlertContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Alert Contact resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Alert Contact and how to use it, see [What is Alert Contact](https://www.alibabacloud.com/help/en/application-real-time-monitoring-service/latest/createalertcontact).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.arms.AlertContact("example", {
 *     alertContactName: "example_value",
 *     dingRobotWebhookUrl: "https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *     email: "someone@example.com",
 *     phoneNum: "1381111****",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.arms.AlertContact("example",
 *     alert_contact_name="example_value",
 *     ding_robot_webhook_url="https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *     email="someone@example.com",
 *     phone_num="1381111****")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Arms.AlertContact("example", new()
 *     {
 *         AlertContactName = "example_value",
 *         DingRobotWebhookUrl = "https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *         Email = "someone@example.com",
 *         PhoneNum = "1381111****",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := arms.NewAlertContact(ctx, "example", &arms.AlertContactArgs{
 * 			AlertContactName:    pulumi.String("example_value"),
 * 			DingRobotWebhookUrl: pulumi.String("https://oapi.dingtalk.com/robot/send?access_token=91f2f6****"),
 * 			Email:               pulumi.String("someone@example.com"),
 * 			PhoneNum:            pulumi.String("1381111****"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.arms.AlertContact;
 * import com.pulumi.alicloud.arms.AlertContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlertContact("example", AlertContactArgs.builder()
 *             .alertContactName("example_value")
 *             .dingRobotWebhookUrl("https://oapi.dingtalk.com/robot/send?access_token=91f2f6****")
 *             .email("someone@example.com")
 *             .phoneNum("1381111****")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:arms:AlertContact
 *     properties:
 *       alertContactName: example_value
 *       dingRobotWebhookUrl: https://oapi.dingtalk.com/robot/send?access_token=91f2f6****
 *       email: someone@example.com
 *       phoneNum: 1381111****
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Alert Contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/alertContact:AlertContact example <id>
 * ```
 * @property alertContactName The name of the alert contact.
 * @property dingRobotWebhookUrl The webhook URL of the DingTalk chatbot. For more information about how to obtain the URL, see Configure a DingTalk chatbot to send alert notifications: https://www.alibabacloud.com/help/en/doc-detail/106247.htm. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
 * @property email The email address of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
 * @property phoneNum The mobile number of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
 * @property systemNoc Specifies whether the alert contact receives system notifications. Valid values:  true: receives system notifications. false: does not receive system notifications.
 */
public data class AlertContactArgs(
    public val alertContactName: Output<String>? = null,
    public val dingRobotWebhookUrl: Output<String>? = null,
    public val email: Output<String>? = null,
    public val phoneNum: Output<String>? = null,
    public val systemNoc: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.AlertContactArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.AlertContactArgs =
        com.pulumi.alicloud.arms.AlertContactArgs.builder()
            .alertContactName(alertContactName?.applyValue({ args0 -> args0 }))
            .dingRobotWebhookUrl(dingRobotWebhookUrl?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .phoneNum(phoneNum?.applyValue({ args0 -> args0 }))
            .systemNoc(systemNoc?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertContactArgs].
 */
@PulumiTagMarker
public class AlertContactArgsBuilder internal constructor() {
    private var alertContactName: Output<String>? = null

    private var dingRobotWebhookUrl: Output<String>? = null

    private var email: Output<String>? = null

    private var phoneNum: Output<String>? = null

    private var systemNoc: Output<Boolean>? = null

    /**
     * @param value The name of the alert contact.
     */
    @JvmName("hgyxxloyupcpdvnw")
    public suspend fun alertContactName(`value`: Output<String>) {
        this.alertContactName = value
    }

    /**
     * @param value The webhook URL of the DingTalk chatbot. For more information about how to obtain the URL, see Configure a DingTalk chatbot to send alert notifications: https://www.alibabacloud.com/help/en/doc-detail/106247.htm. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    @JvmName("oycufnctrbrnkasm")
    public suspend fun dingRobotWebhookUrl(`value`: Output<String>) {
        this.dingRobotWebhookUrl = value
    }

    /**
     * @param value The email address of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    @JvmName("xkfmmiwlqwxkeppi")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The mobile number of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    @JvmName("quyrwftgqwaraknp")
    public suspend fun phoneNum(`value`: Output<String>) {
        this.phoneNum = value
    }

    /**
     * @param value Specifies whether the alert contact receives system notifications. Valid values:  true: receives system notifications. false: does not receive system notifications.
     */
    @JvmName("uekjuedmvelrtbxo")
    public suspend fun systemNoc(`value`: Output<Boolean>) {
        this.systemNoc = value
    }

    /**
     * @param value The name of the alert contact.
     */
    @JvmName("vuljbidkuiettxea")
    public suspend fun alertContactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertContactName = mapped
    }

    /**
     * @param value The webhook URL of the DingTalk chatbot. For more information about how to obtain the URL, see Configure a DingTalk chatbot to send alert notifications: https://www.alibabacloud.com/help/en/doc-detail/106247.htm. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    @JvmName("dickiqgagrghdssl")
    public suspend fun dingRobotWebhookUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dingRobotWebhookUrl = mapped
    }

    /**
     * @param value The email address of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    @JvmName("srsqydxndivdumjf")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The mobile number of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
     */
    @JvmName("adbuantsngcnbnax")
    public suspend fun phoneNum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNum = mapped
    }

    /**
     * @param value Specifies whether the alert contact receives system notifications. Valid values:  true: receives system notifications. false: does not receive system notifications.
     */
    @JvmName("wuksthfnbquqgens")
    public suspend fun systemNoc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemNoc = mapped
    }

    internal fun build(): AlertContactArgs = AlertContactArgs(
        alertContactName = alertContactName,
        dingRobotWebhookUrl = dingRobotWebhookUrl,
        email = email,
        phoneNum = phoneNum,
        systemNoc = systemNoc,
    )
}
