@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AlertContactGroup].
 */
@PulumiTagMarker
public class AlertContactGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertContactGroupArgs = AlertContactGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertContactGroupArgsBuilder.() -> Unit) {
        val builder = AlertContactGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlertContactGroup {
        val builtJavaResource = com.pulumi.alicloud.arms.AlertContactGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlertContactGroup(builtJavaResource)
    }
}

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Alert Contact Group resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Alert Contact Group and how to use it, see [What is Alert Contact Group](https://www.alibabacloud.com/help/en/doc-detail/130677.htm).
 * > **NOTE:** Available since v1.131.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.arms.AlertContact("example", {
 *     alertContactName: "example_value",
 *     dingRobotWebhookUrl: "https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *     email: "someone@example.com",
 *     phoneNum: "1381111****",
 * });
 * const exampleAlertContactGroup = new alicloud.arms.AlertContactGroup("example", {
 *     alertContactGroupName: "example_value",
 *     contactIds: [example&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.arms.AlertContact("example",
 *     alert_contact_name="example_value",
 *     ding_robot_webhook_url="https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *     email="someone@example.com",
 *     phone_num="1381111****")
 * example_alert_contact_group = alicloud.arms.AlertContactGroup("example",
 *     alert_contact_group_name="example_value",
 *     contact_ids=[example&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Arms.AlertContact("example", new()
 *     {
 *         AlertContactName = "example_value",
 *         DingRobotWebhookUrl = "https://oapi.dingtalk.com/robot/send?access_token=91f2f6****",
 *         Email = "someone@example.com",
 *         PhoneNum = "1381111****",
 *     });
 *     var exampleAlertContactGroup = new AliCloud.Arms.AlertContactGroup("example", new()
 *     {
 *         AlertContactGroupName = "example_value",
 *         ContactIds = new[]
 *         {
 *             example.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := arms.NewAlertContact(ctx, "example", &arms.AlertContactArgs{
 * 			AlertContactName:    pulumi.String("example_value"),
 * 			DingRobotWebhookUrl: pulumi.String("https://oapi.dingtalk.com/robot/send?access_token=91f2f6****"),
 * 			Email:               pulumi.String("someone@example.com"),
 * 			PhoneNum:            pulumi.String("1381111****"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewAlertContactGroup(ctx, "example", &arms.AlertContactGroupArgs{
 * 			AlertContactGroupName: pulumi.String("example_value"),
 * 			ContactIds: pulumi.StringArray{
 * 				example.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.arms.AlertContact;
 * import com.pulumi.alicloud.arms.AlertContactArgs;
 * import com.pulumi.alicloud.arms.AlertContactGroup;
 * import com.pulumi.alicloud.arms.AlertContactGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlertContact("example", AlertContactArgs.builder()
 *             .alertContactName("example_value")
 *             .dingRobotWebhookUrl("https://oapi.dingtalk.com/robot/send?access_token=91f2f6****")
 *             .email("someone@example.com")
 *             .phoneNum("1381111****")
 *             .build());
 *         var exampleAlertContactGroup = new AlertContactGroup("exampleAlertContactGroup", AlertContactGroupArgs.builder()
 *             .alertContactGroupName("example_value")
 *             .contactIds(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:arms:AlertContact
 *     properties:
 *       alertContactName: example_value
 *       dingRobotWebhookUrl: https://oapi.dingtalk.com/robot/send?access_token=91f2f6****
 *       email: someone@example.com
 *       phoneNum: 1381111****
 *   exampleAlertContactGroup:
 *     type: alicloud:arms:AlertContactGroup
 *     name: example
 *     properties:
 *       alertContactGroupName: example_value
 *       contactIds:
 *         - ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Alert Contact Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/alertContactGroup:AlertContactGroup example <id>
 * ```
 */
public class AlertContactGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.AlertContactGroup,
) : KotlinCustomResource(javaResource, AlertContactGroupMapper) {
    /**
     * The name of the resource.
     */
    public val alertContactGroupName: Output<String>
        get() = javaResource.alertContactGroupName().applyValue({ args0 -> args0 })

    /**
     * The list id of alert contact.
     */
    public val contactIds: Output<List<String>>?
        get() = javaResource.contactIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object AlertContactGroupMapper : ResourceMapper<AlertContactGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.AlertContactGroup::class == javaResource::class

    override fun map(javaResource: Resource): AlertContactGroup = AlertContactGroup(
        javaResource as
            com.pulumi.alicloud.arms.AlertContactGroup,
    )
}

/**
 * @see [AlertContactGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlertContactGroup].
 */
public suspend fun alertContactGroup(
    name: String,
    block: suspend AlertContactGroupResourceBuilder.() -> Unit,
): AlertContactGroup {
    val builder = AlertContactGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlertContactGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alertContactGroup(name: String): AlertContactGroup {
    val builder = AlertContactGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
