@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.ArmsFunctions.getAlertContactGroupsPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getAlertContactsPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getDispatchRulesPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getIntegrationExportersPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getPrometheisPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getPrometheusAlertRulesPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getPrometheusMonitoringsPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getPrometheusPlain
import com.pulumi.alicloud.arms.ArmsFunctions.getRemoteWritesPlain
import com.pulumi.alicloud.arms.kotlin.inputs.GetAlertContactGroupsPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetAlertContactGroupsPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetAlertContactsPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetAlertContactsPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetDispatchRulesPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetDispatchRulesPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetIntegrationExportersPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetIntegrationExportersPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheisPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheisPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheusAlertRulesPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheusAlertRulesPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheusMonitoringsPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheusMonitoringsPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheusPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetPrometheusPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.GetRemoteWritesPlainArgs
import com.pulumi.alicloud.arms.kotlin.inputs.GetRemoteWritesPlainArgsBuilder
import com.pulumi.alicloud.arms.kotlin.outputs.GetAlertContactGroupsResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetAlertContactsResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetDispatchRulesResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetIntegrationExportersResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheisResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusAlertRulesResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusMonitoringsResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusResult
import com.pulumi.alicloud.arms.kotlin.outputs.GetRemoteWritesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.arms.kotlin.outputs.GetAlertContactGroupsResult.Companion.toKotlin as getAlertContactGroupsResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetAlertContactsResult.Companion.toKotlin as getAlertContactsResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetDispatchRulesResult.Companion.toKotlin as getDispatchRulesResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetIntegrationExportersResult.Companion.toKotlin as getIntegrationExportersResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheisResult.Companion.toKotlin as getPrometheisResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusAlertRulesResult.Companion.toKotlin as getPrometheusAlertRulesResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusMonitoringsResult.Companion.toKotlin as getPrometheusMonitoringsResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusResult.Companion.toKotlin as getPrometheusResultToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.GetRemoteWritesResult.Companion.toKotlin as getRemoteWritesResultToKotlin

public object ArmsFunctions {
    /**
     * This data source provides the Arms Alert Contact Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.131.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.arms.getAlertContactGroups({
     *     nameRegex: "^my-AlertContactGroup",
     * });
     * export const armsAlertContactGroupId = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.arms.get_alert_contact_groups(name_regex="^my-AlertContactGroup")
     * pulumi.export("armsAlertContactGroupId", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.Arms.GetAlertContactGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-AlertContactGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsAlertContactGroupId"] = nameRegex&#46;Apply(getAlertContactGroupsResult => getAlertContactGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := arms.GetAlertContactGroups(ctx, &arms.GetAlertContactGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-AlertContactGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsAlertContactGroupId", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetAlertContactGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = ArmsFunctions.getAlertContactGroups(GetAlertContactGroupsArgs.builder()
     *             .nameRegex("^my-AlertContactGroup")
     *             .build());
     *         ctx.export("armsAlertContactGroupId", nameRegex.applyValue(getAlertContactGroupsResult -> getAlertContactGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getAlertContactGroups
     *       Arguments:
     *         nameRegex: ^my-AlertContactGroup
     * outputs:
     *   armsAlertContactGroupId: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlertContactGroups.
     * @return A collection of values returned by getAlertContactGroups.
     */
    public suspend fun getAlertContactGroups(argument: GetAlertContactGroupsPlainArgs): GetAlertContactGroupsResult =
        getAlertContactGroupsResultToKotlin(getAlertContactGroupsPlain(argument.toJava()).await())

    /**
     * @see [getAlertContactGroups].
     * @param alertContactGroupName The name of the resource.
     * @param contactId The contact id.
     * @param contactName The contact name.
     * @param ids A list of Alert Contact Group IDs.
     * @param nameRegex A regex string to filter results by Alert Contact Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAlertContactGroups.
     */
    public suspend fun getAlertContactGroups(
        alertContactGroupName: String? = null,
        contactId: String? = null,
        contactName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAlertContactGroupsResult {
        val argument = GetAlertContactGroupsPlainArgs(
            alertContactGroupName = alertContactGroupName,
            contactId = contactId,
            contactName = contactName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAlertContactGroupsResultToKotlin(getAlertContactGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlertContactGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetAlertContactGroupsPlainArgs].
     * @return A collection of values returned by getAlertContactGroups.
     */
    public suspend fun getAlertContactGroups(argument: suspend GetAlertContactGroupsPlainArgsBuilder.() -> Unit): GetAlertContactGroupsResult {
        val builder = GetAlertContactGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlertContactGroupsResultToKotlin(getAlertContactGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Alert Contacts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.129.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.arms.getAlertContacts({});
     * export const armsAlertContactId1 = ids.then(ids => ids.contacts?.[0]?.id);
     * const nameRegex = alicloud.arms.getAlertContacts({
     *     nameRegex: "^my-AlertContact",
     * });
     * export const armsAlertContactId2 = nameRegex.then(nameRegex => nameRegex.contacts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.arms.get_alert_contacts()
     * pulumi.export("armsAlertContactId1", ids.contacts[0].id)
     * name_regex = alicloud.arms.get_alert_contacts(name_regex="^my-AlertContact")
     * pulumi.export("armsAlertContactId2", name_regex.contacts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Arms.GetAlertContacts.Invoke();
     *     var nameRegex = AliCloud.Arms.GetAlertContacts.Invoke(new()
     *     {
     *         NameRegex = "^my-AlertContact",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsAlertContactId1"] = ids&#46;Apply(getAlertContactsResult => getAlertContactsResult&#46;Contacts[0]?.Id),
     *         ["armsAlertContactId2"] = nameRegex&#46;Apply(getAlertContactsResult => getAlertContactsResult&#46;Contacts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := arms.GetAlertContacts(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsAlertContactId1", ids.Contacts[0].Id)
     * 		nameRegex, err := arms.GetAlertContacts(ctx, &arms.GetAlertContactsArgs{
     * 			NameRegex: pulumi.StringRef("^my-AlertContact"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsAlertContactId2", nameRegex.Contacts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetAlertContactsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ArmsFunctions.getAlertContacts();
     *         ctx.export("armsAlertContactId1", ids.applyValue(getAlertContactsResult -> getAlertContactsResult.contacts()[0].id()));
     *         final var nameRegex = ArmsFunctions.getAlertContacts(GetAlertContactsArgs.builder()
     *             .nameRegex("^my-AlertContact")
     *             .build());
     *         ctx.export("armsAlertContactId2", nameRegex.applyValue(getAlertContactsResult -> getAlertContactsResult.contacts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:arms:getAlertContacts
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getAlertContacts
     *       Arguments:
     *         nameRegex: ^my-AlertContact
     * outputs:
     *   armsAlertContactId1: ${ids.contacts[0].id}
     *   armsAlertContactId2: ${nameRegex.contacts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlertContacts.
     * @return A collection of values returned by getAlertContacts.
     */
    public suspend fun getAlertContacts(argument: GetAlertContactsPlainArgs): GetAlertContactsResult =
        getAlertContactsResultToKotlin(getAlertContactsPlain(argument.toJava()).await())

    /**
     * @see [getAlertContacts].
     * @param alertContactName The name of the alert contact.
     * @param email The email address of the alert contact.
     * @param ids A list of Alert Contact IDs.
     * @param nameRegex A regex string to filter results by Alert Contact name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param phoneNum The mobile number of the alert contact.
     * @return A collection of values returned by getAlertContacts.
     */
    public suspend fun getAlertContacts(
        alertContactName: String? = null,
        email: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        phoneNum: String? = null,
    ): GetAlertContactsResult {
        val argument = GetAlertContactsPlainArgs(
            alertContactName = alertContactName,
            email = email,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            phoneNum = phoneNum,
        )
        return getAlertContactsResultToKotlin(getAlertContactsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlertContacts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetAlertContactsPlainArgs].
     * @return A collection of values returned by getAlertContacts.
     */
    public suspend fun getAlertContacts(argument: suspend GetAlertContactsPlainArgsBuilder.() -> Unit): GetAlertContactsResult {
        val builder = GetAlertContactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlertContactsResultToKotlin(getAlertContactsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Dispatch Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.arms.getDispatchRules({});
     * export const armsDispatchRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const nameRegex = alicloud.arms.getDispatchRules({
     *     nameRegex: "^my-DispatchRule",
     * });
     * export const armsDispatchRuleId2 = nameRegex.then(nameRegex => nameRegex.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.arms.get_dispatch_rules()
     * pulumi.export("armsDispatchRuleId1", ids.rules[0].id)
     * name_regex = alicloud.arms.get_dispatch_rules(name_regex="^my-DispatchRule")
     * pulumi.export("armsDispatchRuleId2", name_regex.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Arms.GetDispatchRules.Invoke();
     *     var nameRegex = AliCloud.Arms.GetDispatchRules.Invoke(new()
     *     {
     *         NameRegex = "^my-DispatchRule",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsDispatchRuleId1"] = ids&#46;Apply(getDispatchRulesResult => getDispatchRulesResult&#46;Rules[0]?.Id),
     *         ["armsDispatchRuleId2"] = nameRegex&#46;Apply(getDispatchRulesResult => getDispatchRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := arms.GetDispatchRules(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsDispatchRuleId1", ids.Rules[0].Id)
     * 		nameRegex, err := arms.GetDispatchRules(ctx, &arms.GetDispatchRulesArgs{
     * 			NameRegex: pulumi.StringRef("^my-DispatchRule"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsDispatchRuleId2", nameRegex.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetDispatchRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ArmsFunctions.getDispatchRules();
     *         ctx.export("armsDispatchRuleId1", ids.applyValue(getDispatchRulesResult -> getDispatchRulesResult.rules()[0].id()));
     *         final var nameRegex = ArmsFunctions.getDispatchRules(GetDispatchRulesArgs.builder()
     *             .nameRegex("^my-DispatchRule")
     *             .build());
     *         ctx.export("armsDispatchRuleId2", nameRegex.applyValue(getDispatchRulesResult -> getDispatchRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:arms:getDispatchRules
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getDispatchRules
     *       Arguments:
     *         nameRegex: ^my-DispatchRule
     * outputs:
     *   armsDispatchRuleId1: ${ids.rules[0].id}
     *   armsDispatchRuleId2: ${nameRegex.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDispatchRules.
     * @return A collection of values returned by getDispatchRules.
     */
    public suspend fun getDispatchRules(argument: GetDispatchRulesPlainArgs): GetDispatchRulesResult =
        getDispatchRulesResultToKotlin(getDispatchRulesPlain(argument.toJava()).await())

    /**
     * @see [getDispatchRules].
     * @param dispatchRuleName The name of the dispatch rule.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of dispatch rule id.
     * @param nameRegex A regex string to filter results by Dispatch Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDispatchRules.
     */
    public suspend fun getDispatchRules(
        dispatchRuleName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDispatchRulesResult {
        val argument = GetDispatchRulesPlainArgs(
            dispatchRuleName = dispatchRuleName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDispatchRulesResultToKotlin(getDispatchRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDispatchRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetDispatchRulesPlainArgs].
     * @return A collection of values returned by getDispatchRules.
     */
    public suspend fun getDispatchRules(argument: suspend GetDispatchRulesPlainArgsBuilder.() -> Unit): GetDispatchRulesResult {
        val builder = GetDispatchRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDispatchRulesResultToKotlin(getDispatchRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Integration Exporters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.203.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.arms.getIntegrationExporters({
     *     ids: ["example_id"],
     *     clusterId: "your_cluster_id",
     *     integrationType: "kafka",
     * });
     * export const armsIntegrationExportersId1 = ids.then(ids => ids.integrationExporters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.arms.get_integration_exporters(ids=["example_id"],
     *     cluster_id="your_cluster_id",
     *     integration_type="kafka")
     * pulumi.export("armsIntegrationExportersId1", ids.integration_exporters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Arms.GetIntegrationExporters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         ClusterId = "your_cluster_id",
     *         IntegrationType = "kafka",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsIntegrationExportersId1"] = ids&#46;Apply(getIntegrationExportersResult => getIntegrationExportersResult&#46;IntegrationExporters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := arms.GetIntegrationExporters(ctx, &arms.GetIntegrationExportersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			ClusterId:       "your_cluster_id",
     * 			IntegrationType: "kafka",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsIntegrationExportersId1", ids.IntegrationExporters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetIntegrationExportersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ArmsFunctions.getIntegrationExporters(GetIntegrationExportersArgs.builder()
     *             .ids("example_id")
     *             .clusterId("your_cluster_id")
     *             .integrationType("kafka")
     *             .build());
     *         ctx.export("armsIntegrationExportersId1", ids.applyValue(getIntegrationExportersResult -> getIntegrationExportersResult.integrationExporters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:arms:getIntegrationExporters
     *       Arguments:
     *         ids:
     *           - example_id
     *         clusterId: your_cluster_id
     *         integrationType: kafka
     * outputs:
     *   armsIntegrationExportersId1: ${ids.integrationExporters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIntegrationExporters.
     * @return A collection of values returned by getIntegrationExporters.
     */
    public suspend fun getIntegrationExporters(argument: GetIntegrationExportersPlainArgs): GetIntegrationExportersResult =
        getIntegrationExportersResultToKotlin(getIntegrationExportersPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationExporters].
     * @param clusterId The ID of the Prometheus instance.
     * @param ids A list of Integration Exporter IDs.
     * @param integrationType The type of prometheus integration.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getIntegrationExporters.
     */
    public suspend fun getIntegrationExporters(
        clusterId: String,
        ids: List<String>? = null,
        integrationType: String,
        outputFile: String? = null,
    ): GetIntegrationExportersResult {
        val argument = GetIntegrationExportersPlainArgs(
            clusterId = clusterId,
            ids = ids,
            integrationType = integrationType,
            outputFile = outputFile,
        )
        return getIntegrationExportersResultToKotlin(getIntegrationExportersPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationExporters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetIntegrationExportersPlainArgs].
     * @return A collection of values returned by getIntegrationExporters.
     */
    public suspend fun getIntegrationExporters(argument: suspend GetIntegrationExportersPlainArgsBuilder.() -> Unit): GetIntegrationExportersResult {
        val builder = GetIntegrationExportersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationExportersResultToKotlin(getIntegrationExportersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Prometheis of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.203.0.
     * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsDisk from version 1.214.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-example";
     * const default = alicloud.vpc.getNetworks({
     *     nameRegex: "default-NODELETING",
     * });
     * const defaultGetSwitches = _default.then(_default => alicloud.vpc.getSwitches({
     *     vpcId: _default.ids?.[0],
     * }));
     * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
     * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: _default.then(_default => _default.ids?.[0])});
     * const defaultPrometheus = new alicloud.arms.Prometheus("default", {
     *     clusterType: "ecs",
     *     grafanaInstanceId: "free",
     *     vpcId: _default.then(_default => _default.ids?.[0]),
     *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
     *     securityGroupId: defaultSecurityGroup.id,
     *     clusterName: _default.then(_default => `${name}-${_default.ids?.[0]}`),
     *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.groups?.[1]?.id),
     *     tags: {
     *         Created: "TF",
     *         For: "Prometheus",
     *     },
     * });
     * const nameRegex = alicloud.arms.getPrometheisOutput({
     *     nameRegex: defaultPrometheus.clusterName,
     * });
     * export const armsPrometheisId = nameRegex.apply(nameRegex => nameRegex.prometheis?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-example"
     * default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
     * default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0])
     * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
     * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default.ids[0])
     * default_prometheus = alicloud.arms.Prometheus("default",
     *     cluster_type="ecs",
     *     grafana_instance_id="free",
     *     vpc_id=default.ids[0],
     *     vswitch_id=default_get_switches.ids[0],
     *     security_group_id=default_security_group.id,
     *     cluster_name=f"{name}-{default.ids[0]}",
     *     resource_group_id=default_get_resource_groups.groups[1].id,
     *     tags={
     *         "Created": "TF",
     *         "For": "Prometheus",
     *     })
     * name_regex = alicloud.arms.get_prometheis_output(name_regex=default_prometheus.cluster_name)
     * pulumi.export("armsPrometheisId", name_regex.prometheis[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-example";
     *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
     *     {
     *         NameRegex = "default-NODELETING",
     *     });
     *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         VpcId = @default.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *     });
     *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
     *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
     *     {
     *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
     *     });
     *     var defaultPrometheus = new AliCloud.Arms.Prometheus("default", new()
     *     {
     *         ClusterType = "ecs",
     *         GrafanaInstanceId = "free",
     *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
     *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
     *         SecurityGroupId = defaultSecurityGroup.Id,
     *         ClusterName = @default.Apply(@default => $"{name}-{@default.Apply(getNetworksResult => getNetworksResult.Ids[0])}"),
     *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[1]?.Id),
     *         Tags =
     *         {
     *             { "Created", "TF" },
     *             { "For", "Prometheus" },
     *         },
     *     });
     *     var nameRegex = AliCloud.Arms.GetPrometheis.Invoke(new()
     *     {
     *         NameRegex = defaultPrometheus.ClusterName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsPrometheisId"] = nameRegex&#46;Apply(getPrometheisResult => getPrometheisResult&#46;Prometheis[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
     * 			NameRegex: pulumi.StringRef("default-NODELETING"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
     * 			VpcId: pulumi.StringRef(_default.Ids[0]),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
     * 			VpcId: pulumi.String(_default.Ids[0]),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultPrometheus, err := arms.NewPrometheus(ctx, "default", &arms.PrometheusArgs{
     * 			ClusterType:       pulumi.String("ecs"),
     * 			GrafanaInstanceId: pulumi.String("free"),
     * 			VpcId:             pulumi.String(_default.Ids[0]),
     * 			VswitchId:         pulumi.String(defaultGetSwitches.Ids[0]),
     * 			SecurityGroupId:   defaultSecurityGroup.ID(),
     * 			ClusterName:       pulumi.Sprintf("%v-%v", name, _default.Ids[0]),
     * 			ResourceGroupId:   pulumi.String(defaultGetResourceGroups.Groups[1].Id),
     * 			Tags: pulumi.StringMap{
     * 				"Created": pulumi.String("TF"),
     * 				"For":     pulumi.String("Prometheus"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		nameRegex := arms.GetPrometheisOutput(ctx, arms.GetPrometheisOutputArgs{
     * 			NameRegex: defaultPrometheus.ClusterName,
     * 		}, nil)
     * 		ctx.Export("armsPrometheisId", nameRegex.ApplyT(func(nameRegex arms.GetPrometheisResult) (*string, error) {
     * 			return &nameRegex.Prometheis[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
     * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroup;
     * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
     * import com.pulumi.alicloud.arms.Prometheus;
     * import com.pulumi.alicloud.arms.PrometheusArgs;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetPrometheisArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-example");
     *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
     *             .nameRegex("default-NODELETING")
     *             .build());
     *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .vpcId(default_.ids()[0])
     *             .build());
     *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
     *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
     *             .vpcId(default_.ids()[0])
     *             .build());
     *         var defaultPrometheus = new Prometheus("defaultPrometheus", PrometheusArgs.builder()
     *             .clusterType("ecs")
     *             .grafanaInstanceId("free")
     *             .vpcId(default_.ids()[0])
     *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
     *             .securityGroupId(defaultSecurityGroup.id())
     *             .clusterName(String.format("%s-%s", name,default_.ids()[0]))
     *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[1].id()))
     *             .tags(Map.ofEntries(
     *                 Map.entry("Created", "TF"),
     *                 Map.entry("For", "Prometheus")
     *             ))
     *             .build());
     *         final var nameRegex = ArmsFunctions.getPrometheis(GetPrometheisArgs.builder()
     *             .nameRegex(defaultPrometheus.clusterName())
     *             .build());
     *         ctx.export("armsPrometheisId", nameRegex.applyValue(getPrometheisResult -> getPrometheisResult).applyValue(nameRegex -> nameRegex.applyValue(getPrometheisResult -> getPrometheisResult.prometheis()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-example
     * resources:
     *   defaultSecurityGroup:
     *     type: alicloud:ecs:SecurityGroup
     *     name: default
     *     properties:
     *       vpcId: ${default.ids[0]}
     *   defaultPrometheus:
     *     type: alicloud:arms:Prometheus
     *     name: default
     *     properties:
     *       clusterType: ecs
     *       grafanaInstanceId: free
     *       vpcId: ${default.ids[0]}
     *       vswitchId: ${defaultGetSwitches.ids[0]}
     *       securityGroupId: ${defaultSecurityGroup.id}
     *       clusterName: ${name}-${default.ids[0]}
     *       resourceGroupId: ${defaultGetResourceGroups.groups[1].id}
     *       tags:
     *         Created: TF
     *         For: Prometheus
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNetworks
     *       Arguments:
     *         nameRegex: default-NODELETING
     *   defaultGetSwitches:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSwitches
     *       Arguments:
     *         vpcId: ${default.ids[0]}
     *   defaultGetResourceGroups:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getResourceGroups
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getPrometheis
     *       Arguments:
     *         nameRegex: ${defaultPrometheus.clusterName}
     * outputs:
     *   armsPrometheisId: ${nameRegex.prometheis[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrometheis.
     * @return A collection of values returned by getPrometheis.
     */
    public suspend fun getPrometheis(argument: GetPrometheisPlainArgs): GetPrometheisResult =
        getPrometheisResultToKotlin(getPrometheisPlain(argument.toJava()).await())

    /**
     * @see [getPrometheis].
     * @param enableDetails Whether to query details about the instance.
     * @param ids A list of Prometheus IDs.
     * @param nameRegex A regex string to filter results by Prometheus name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getPrometheis.
     */
    public suspend fun getPrometheis(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetPrometheisResult {
        val argument = GetPrometheisPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getPrometheisResultToKotlin(getPrometheisPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrometheis].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetPrometheisPlainArgs].
     * @return A collection of values returned by getPrometheis.
     */
    public suspend fun getPrometheis(argument: suspend GetPrometheisPlainArgsBuilder.() -> Unit): GetPrometheisResult {
        val builder = GetPrometheisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrometheisResultToKotlin(getPrometheisPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Prometheus of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.214.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-example";
     * const default = alicloud.vpc.getNetworks({
     *     nameRegex: "default-NODELETING",
     * });
     * const defaultGetSwitches = _default.then(_default => alicloud.vpc.getSwitches({
     *     vpcId: _default.ids?.[0],
     * }));
     * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
     * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: _default.then(_default => _default.ids?.[0])});
     * const defaultPrometheus = new alicloud.arms.Prometheus("default", {
     *     clusterType: "ecs",
     *     grafanaInstanceId: "free",
     *     vpcId: _default.then(_default => _default.ids?.[0]),
     *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
     *     securityGroupId: defaultSecurityGroup.id,
     *     clusterName: _default.then(_default => `${name}-${_default.ids?.[0]}`),
     *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.groups?.[1]?.id),
     *     tags: {
     *         Created: "TF",
     *         For: "Prometheus",
     *     },
     * });
     * const nameRegex = alicloud.arms.getPrometheusOutput({
     *     nameRegex: defaultPrometheus.clusterName,
     * });
     * export const armsPrometheusId = nameRegex.apply(nameRegex => nameRegex.prometheis?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-example"
     * default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
     * default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0])
     * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
     * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default.ids[0])
     * default_prometheus = alicloud.arms.Prometheus("default",
     *     cluster_type="ecs",
     *     grafana_instance_id="free",
     *     vpc_id=default.ids[0],
     *     vswitch_id=default_get_switches.ids[0],
     *     security_group_id=default_security_group.id,
     *     cluster_name=f"{name}-{default.ids[0]}",
     *     resource_group_id=default_get_resource_groups.groups[1].id,
     *     tags={
     *         "Created": "TF",
     *         "For": "Prometheus",
     *     })
     * name_regex = alicloud.arms.get_prometheus_output(name_regex=default_prometheus.cluster_name)
     * pulumi.export("armsPrometheusId", name_regex.prometheis[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-example";
     *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
     *     {
     *         NameRegex = "default-NODELETING",
     *     });
     *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         VpcId = @default.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *     });
     *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
     *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
     *     {
     *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
     *     });
     *     var defaultPrometheus = new AliCloud.Arms.Prometheus("default", new()
     *     {
     *         ClusterType = "ecs",
     *         GrafanaInstanceId = "free",
     *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
     *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
     *         SecurityGroupId = defaultSecurityGroup.Id,
     *         ClusterName = @default.Apply(@default => $"{name}-{@default.Apply(getNetworksResult => getNetworksResult.Ids[0])}"),
     *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[1]?.Id),
     *         Tags =
     *         {
     *             { "Created", "TF" },
     *             { "For", "Prometheus" },
     *         },
     *     });
     *     var nameRegex = AliCloud.Arms.GetPrometheus.Invoke(new()
     *     {
     *         NameRegex = defaultPrometheus.ClusterName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsPrometheusId"] = nameRegex&#46;Apply(getPrometheusResult => getPrometheusResult&#46;Prometheis[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
     * 			NameRegex: pulumi.StringRef("default-NODELETING"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
     * 			VpcId: pulumi.StringRef(_default.Ids[0]),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
     * 			VpcId: pulumi.String(_default.Ids[0]),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultPrometheus, err := arms.NewPrometheus(ctx, "default", &arms.PrometheusArgs{
     * 			ClusterType:       pulumi.String("ecs"),
     * 			GrafanaInstanceId: pulumi.String("free"),
     * 			VpcId:             pulumi.String(_default.Ids[0]),
     * 			VswitchId:         pulumi.String(defaultGetSwitches.Ids[0]),
     * 			SecurityGroupId:   defaultSecurityGroup.ID(),
     * 			ClusterName:       pulumi.Sprintf("%v-%v", name, _default.Ids[0]),
     * 			ResourceGroupId:   pulumi.String(defaultGetResourceGroups.Groups[1].Id),
     * 			Tags: pulumi.StringMap{
     * 				"Created": pulumi.String("TF"),
     * 				"For":     pulumi.String("Prometheus"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		nameRegex := arms.LookupPrometheusOutput(ctx, arms.GetPrometheusOutputArgs{
     * 			NameRegex: defaultPrometheus.ClusterName,
     * 		}, nil)
     * 		ctx.Export("armsPrometheusId", nameRegex.ApplyT(func(nameRegex arms.GetPrometheusResult) (*string, error) {
     * 			return &nameRegex.Prometheis[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
     * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroup;
     * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
     * import com.pulumi.alicloud.arms.Prometheus;
     * import com.pulumi.alicloud.arms.PrometheusArgs;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetPrometheusArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-example");
     *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
     *             .nameRegex("default-NODELETING")
     *             .build());
     *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .vpcId(default_.ids()[0])
     *             .build());
     *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
     *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
     *             .vpcId(default_.ids()[0])
     *             .build());
     *         var defaultPrometheus = new Prometheus("defaultPrometheus", PrometheusArgs.builder()
     *             .clusterType("ecs")
     *             .grafanaInstanceId("free")
     *             .vpcId(default_.ids()[0])
     *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
     *             .securityGroupId(defaultSecurityGroup.id())
     *             .clusterName(String.format("%s-%s", name,default_.ids()[0]))
     *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[1].id()))
     *             .tags(Map.ofEntries(
     *                 Map.entry("Created", "TF"),
     *                 Map.entry("For", "Prometheus")
     *             ))
     *             .build());
     *         final var nameRegex = ArmsFunctions.getPrometheus(GetPrometheusArgs.builder()
     *             .nameRegex(defaultPrometheus.clusterName())
     *             .build());
     *         ctx.export("armsPrometheusId", nameRegex.applyValue(getPrometheusResult -> getPrometheusResult).applyValue(nameRegex -> nameRegex.applyValue(getPrometheusResult -> getPrometheusResult.prometheis()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-example
     * resources:
     *   defaultSecurityGroup:
     *     type: alicloud:ecs:SecurityGroup
     *     name: default
     *     properties:
     *       vpcId: ${default.ids[0]}
     *   defaultPrometheus:
     *     type: alicloud:arms:Prometheus
     *     name: default
     *     properties:
     *       clusterType: ecs
     *       grafanaInstanceId: free
     *       vpcId: ${default.ids[0]}
     *       vswitchId: ${defaultGetSwitches.ids[0]}
     *       securityGroupId: ${defaultSecurityGroup.id}
     *       clusterName: ${name}-${default.ids[0]}
     *       resourceGroupId: ${defaultGetResourceGroups.groups[1].id}
     *       tags:
     *         Created: TF
     *         For: Prometheus
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNetworks
     *       Arguments:
     *         nameRegex: default-NODELETING
     *   defaultGetSwitches:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSwitches
     *       Arguments:
     *         vpcId: ${default.ids[0]}
     *   defaultGetResourceGroups:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getResourceGroups
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getPrometheus
     *       Arguments:
     *         nameRegex: ${defaultPrometheus.clusterName}
     * outputs:
     *   armsPrometheusId: ${nameRegex.prometheis[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrometheus.
     * @return A collection of values returned by getPrometheus.
     */
    public suspend fun getPrometheus(argument: GetPrometheusPlainArgs): GetPrometheusResult =
        getPrometheusResultToKotlin(getPrometheusPlain(argument.toJava()).await())

    /**
     * @see [getPrometheus].
     * @param enableDetails Whether to query details about the instance.
     * @param ids A list of Prometheus IDs.
     * @param nameRegex A regex string to filter results by Prometheus name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getPrometheus.
     */
    public suspend fun getPrometheus(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetPrometheusResult {
        val argument = GetPrometheusPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getPrometheusResultToKotlin(getPrometheusPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrometheus].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetPrometheusPlainArgs].
     * @return A collection of values returned by getPrometheus.
     */
    public suspend fun getPrometheus(argument: suspend GetPrometheusPlainArgsBuilder.() -> Unit): GetPrometheusResult {
        val builder = GetPrometheusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrometheusResultToKotlin(getPrometheusPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Prometheus Alert Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.arms.getPrometheusAlertRules({
     *     clusterId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const armsPrometheusAlertRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const nameRegex = alicloud.arms.getPrometheusAlertRules({
     *     clusterId: "example_value",
     *     nameRegex: "^my-PrometheusAlertRule",
     * });
     * export const armsPrometheusAlertRuleId2 = nameRegex.then(nameRegex => nameRegex.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.arms.get_prometheus_alert_rules(cluster_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("armsPrometheusAlertRuleId1", ids.rules[0].id)
     * name_regex = alicloud.arms.get_prometheus_alert_rules(cluster_id="example_value",
     *     name_regex="^my-PrometheusAlertRule")
     * pulumi.export("armsPrometheusAlertRuleId2", name_regex.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Arms.GetPrometheusAlertRules.Invoke(new()
     *     {
     *         ClusterId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Arms.GetPrometheusAlertRules.Invoke(new()
     *     {
     *         ClusterId = "example_value",
     *         NameRegex = "^my-PrometheusAlertRule",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsPrometheusAlertRuleId1"] = ids&#46;Apply(getPrometheusAlertRulesResult => getPrometheusAlertRulesResult&#46;Rules[0]?.Id),
     *         ["armsPrometheusAlertRuleId2"] = nameRegex&#46;Apply(getPrometheusAlertRulesResult => getPrometheusAlertRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := arms.GetPrometheusAlertRules(ctx, &arms.GetPrometheusAlertRulesArgs{
     * 			ClusterId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsPrometheusAlertRuleId1", ids.Rules[0].Id)
     * 		nameRegex, err := arms.GetPrometheusAlertRules(ctx, &arms.GetPrometheusAlertRulesArgs{
     * 			ClusterId: "example_value",
     * 			NameRegex: pulumi.StringRef("^my-PrometheusAlertRule"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsPrometheusAlertRuleId2", nameRegex.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetPrometheusAlertRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ArmsFunctions.getPrometheusAlertRules(GetPrometheusAlertRulesArgs.builder()
     *             .clusterId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("armsPrometheusAlertRuleId1", ids.applyValue(getPrometheusAlertRulesResult -> getPrometheusAlertRulesResult.rules()[0].id()));
     *         final var nameRegex = ArmsFunctions.getPrometheusAlertRules(GetPrometheusAlertRulesArgs.builder()
     *             .clusterId("example_value")
     *             .nameRegex("^my-PrometheusAlertRule")
     *             .build());
     *         ctx.export("armsPrometheusAlertRuleId2", nameRegex.applyValue(getPrometheusAlertRulesResult -> getPrometheusAlertRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:arms:getPrometheusAlertRules
     *       Arguments:
     *         clusterId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getPrometheusAlertRules
     *       Arguments:
     *         clusterId: example_value
     *         nameRegex: ^my-PrometheusAlertRule
     * outputs:
     *   armsPrometheusAlertRuleId1: ${ids.rules[0].id}
     *   armsPrometheusAlertRuleId2: ${nameRegex.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrometheusAlertRules.
     * @return A collection of values returned by getPrometheusAlertRules.
     */
    public suspend fun getPrometheusAlertRules(argument: GetPrometheusAlertRulesPlainArgs): GetPrometheusAlertRulesResult =
        getPrometheusAlertRulesResultToKotlin(getPrometheusAlertRulesPlain(argument.toJava()).await())

    /**
     * @see [getPrometheusAlertRules].
     * @param clusterId The ID of the cluster.
     * @param ids A list of Prometheus Alert Rule IDs.
     * @param matchExpressions
     * @param nameRegex A regex string to filter results by Prometheus Alert Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `0`, `1`.
     * @param type The type of the alert rule.
     * @return A collection of values returned by getPrometheusAlertRules.
     */
    public suspend fun getPrometheusAlertRules(
        clusterId: String,
        ids: List<String>? = null,
        matchExpressions: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
        type: String? = null,
    ): GetPrometheusAlertRulesResult {
        val argument = GetPrometheusAlertRulesPlainArgs(
            clusterId = clusterId,
            ids = ids,
            matchExpressions = matchExpressions,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            type = type,
        )
        return getPrometheusAlertRulesResultToKotlin(getPrometheusAlertRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrometheusAlertRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetPrometheusAlertRulesPlainArgs].
     * @return A collection of values returned by getPrometheusAlertRules.
     */
    public suspend fun getPrometheusAlertRules(argument: suspend GetPrometheusAlertRulesPlainArgsBuilder.() -> Unit): GetPrometheusAlertRulesResult {
        val builder = GetPrometheusAlertRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrometheusAlertRulesResultToKotlin(getPrometheusAlertRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Prometheus Monitorings of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.210.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.arms.getPrometheusMonitorings({
     *     clusterId: "your_cluster_id",
     *     ids: ["example_id"],
     * });
     * export const armsPrometheusMonitoringsId1 = ids.then(ids => ids.prometheusMonitorings?.[0]?.id);
     * const nameRegex = alicloud.arms.getPrometheusMonitorings({
     *     clusterId: "your_cluster_id",
     *     nameRegex: "tf-example",
     * });
     * export const armsPrometheusMonitoringsId2 = nameRegex.then(nameRegex => nameRegex.prometheusMonitorings?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.arms.get_prometheus_monitorings(cluster_id="your_cluster_id",
     *     ids=["example_id"])
     * pulumi.export("armsPrometheusMonitoringsId1", ids.prometheus_monitorings[0].id)
     * name_regex = alicloud.arms.get_prometheus_monitorings(cluster_id="your_cluster_id",
     *     name_regex="tf-example")
     * pulumi.export("armsPrometheusMonitoringsId2", name_regex.prometheus_monitorings[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Arms.GetPrometheusMonitorings.Invoke(new()
     *     {
     *         ClusterId = "your_cluster_id",
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Arms.GetPrometheusMonitorings.Invoke(new()
     *     {
     *         ClusterId = "your_cluster_id",
     *         NameRegex = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsPrometheusMonitoringsId1"] = ids&#46;Apply(getPrometheusMonitoringsResult => getPrometheusMonitoringsResult&#46;PrometheusMonitorings[0]?.Id),
     *         ["armsPrometheusMonitoringsId2"] = nameRegex&#46;Apply(getPrometheusMonitoringsResult => getPrometheusMonitoringsResult&#46;PrometheusMonitorings[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := arms.GetPrometheusMonitorings(ctx, &arms.GetPrometheusMonitoringsArgs{
     * 			ClusterId: "your_cluster_id",
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsPrometheusMonitoringsId1", ids.PrometheusMonitorings[0].Id)
     * 		nameRegex, err := arms.GetPrometheusMonitorings(ctx, &arms.GetPrometheusMonitoringsArgs{
     * 			ClusterId: "your_cluster_id",
     * 			NameRegex: pulumi.StringRef("tf-example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsPrometheusMonitoringsId2", nameRegex.PrometheusMonitorings[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetPrometheusMonitoringsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ArmsFunctions.getPrometheusMonitorings(GetPrometheusMonitoringsArgs.builder()
     *             .clusterId("your_cluster_id")
     *             .ids("example_id")
     *             .build());
     *         ctx.export("armsPrometheusMonitoringsId1", ids.applyValue(getPrometheusMonitoringsResult -> getPrometheusMonitoringsResult.prometheusMonitorings()[0].id()));
     *         final var nameRegex = ArmsFunctions.getPrometheusMonitorings(GetPrometheusMonitoringsArgs.builder()
     *             .clusterId("your_cluster_id")
     *             .nameRegex("tf-example")
     *             .build());
     *         ctx.export("armsPrometheusMonitoringsId2", nameRegex.applyValue(getPrometheusMonitoringsResult -> getPrometheusMonitoringsResult.prometheusMonitorings()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:arms:getPrometheusMonitorings
     *       Arguments:
     *         clusterId: your_cluster_id
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getPrometheusMonitorings
     *       Arguments:
     *         clusterId: your_cluster_id
     *         nameRegex: tf-example
     * outputs:
     *   armsPrometheusMonitoringsId1: ${ids.prometheusMonitorings[0].id}
     *   armsPrometheusMonitoringsId2: ${nameRegex.prometheusMonitorings[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrometheusMonitorings.
     * @return A collection of values returned by getPrometheusMonitorings.
     */
    public suspend fun getPrometheusMonitorings(argument: GetPrometheusMonitoringsPlainArgs): GetPrometheusMonitoringsResult =
        getPrometheusMonitoringsResultToKotlin(getPrometheusMonitoringsPlain(argument.toJava()).await())

    /**
     * @see [getPrometheusMonitorings].
     * @param clusterId The ID of the Prometheus instance.
     * @param ids A list of Prometheus Monitoring IDs.
     * @param nameRegex A regex string to filter results by Prometheus Monitoring name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the monitoring configuration. Valid values: `run`, `stop`.
     * @param type The type of the monitoring configuration. Valid values: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
     * @return A collection of values returned by getPrometheusMonitorings.
     */
    public suspend fun getPrometheusMonitorings(
        clusterId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        type: String? = null,
    ): GetPrometheusMonitoringsResult {
        val argument = GetPrometheusMonitoringsPlainArgs(
            clusterId = clusterId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            type = type,
        )
        return getPrometheusMonitoringsResultToKotlin(getPrometheusMonitoringsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrometheusMonitorings].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetPrometheusMonitoringsPlainArgs].
     * @return A collection of values returned by getPrometheusMonitorings.
     */
    public suspend fun getPrometheusMonitorings(argument: suspend GetPrometheusMonitoringsPlainArgsBuilder.() -> Unit): GetPrometheusMonitoringsResult {
        val builder = GetPrometheusMonitoringsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrometheusMonitoringsResultToKotlin(getPrometheusMonitoringsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Arms Remote Writes of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.204.0+.
     * > **NOTE:** deprecated since v1.228.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.arms.getRemoteWrites({
     *     ids: ["example_id"],
     *     clusterId: "your_cluster_id",
     * });
     * export const armsRemoteWritesId1 = ids.then(ids => ids.remoteWrites?.[0]?.id);
     * const nameRegex = alicloud.arms.getRemoteWrites({
     *     nameRegex: "tf-example",
     *     clusterId: "your_cluster_id",
     * });
     * export const armsRemoteWritesId2 = nameRegex.then(nameRegex => nameRegex.remoteWrites?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.arms.get_remote_writes(ids=["example_id"],
     *     cluster_id="your_cluster_id")
     * pulumi.export("armsRemoteWritesId1", ids.remote_writes[0].id)
     * name_regex = alicloud.arms.get_remote_writes(name_regex="tf-example",
     *     cluster_id="your_cluster_id")
     * pulumi.export("armsRemoteWritesId2", name_regex.remote_writes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Arms.GetRemoteWrites.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         ClusterId = "your_cluster_id",
     *     });
     *     var nameRegex = AliCloud.Arms.GetRemoteWrites.Invoke(new()
     *     {
     *         NameRegex = "tf-example",
     *         ClusterId = "your_cluster_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsRemoteWritesId1"] = ids&#46;Apply(getRemoteWritesResult => getRemoteWritesResult&#46;RemoteWrites[0]?.Id),
     *         ["armsRemoteWritesId2"] = nameRegex&#46;Apply(getRemoteWritesResult => getRemoteWritesResult&#46;RemoteWrites[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := arms.GetRemoteWrites(ctx, &arms.GetRemoteWritesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			ClusterId: "your_cluster_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsRemoteWritesId1", ids.RemoteWrites[0].Id)
     * 		nameRegex, err := arms.GetRemoteWrites(ctx, &arms.GetRemoteWritesArgs{
     * 			NameRegex: pulumi.StringRef("tf-example"),
     * 			ClusterId: "your_cluster_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsRemoteWritesId2", nameRegex.RemoteWrites[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.arms.ArmsFunctions;
     * import com.pulumi.alicloud.arms.inputs.GetRemoteWritesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ArmsFunctions.getRemoteWrites(GetRemoteWritesArgs.builder()
     *             .ids("example_id")
     *             .clusterId("your_cluster_id")
     *             .build());
     *         ctx.export("armsRemoteWritesId1", ids.applyValue(getRemoteWritesResult -> getRemoteWritesResult.remoteWrites()[0].id()));
     *         final var nameRegex = ArmsFunctions.getRemoteWrites(GetRemoteWritesArgs.builder()
     *             .nameRegex("tf-example")
     *             .clusterId("your_cluster_id")
     *             .build());
     *         ctx.export("armsRemoteWritesId2", nameRegex.applyValue(getRemoteWritesResult -> getRemoteWritesResult.remoteWrites()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:arms:getRemoteWrites
     *       Arguments:
     *         ids:
     *           - example_id
     *         clusterId: your_cluster_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:arms:getRemoteWrites
     *       Arguments:
     *         nameRegex: tf-example
     *         clusterId: your_cluster_id
     * outputs:
     *   armsRemoteWritesId1: ${ids.remoteWrites[0].id}
     *   armsRemoteWritesId2: ${nameRegex.remoteWrites[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRemoteWrites.
     * @return A collection of values returned by getRemoteWrites.
     */
    public suspend fun getRemoteWrites(argument: GetRemoteWritesPlainArgs): GetRemoteWritesResult =
        getRemoteWritesResultToKotlin(getRemoteWritesPlain(argument.toJava()).await())

    /**
     * @see [getRemoteWrites].
     * @param clusterId The ID of the Prometheus instance.
     * @param ids A list of Remote Write IDs.
     * @param nameRegex A regex string to filter results by Remote Write name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRemoteWrites.
     */
    public suspend fun getRemoteWrites(
        clusterId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRemoteWritesResult {
        val argument = GetRemoteWritesPlainArgs(
            clusterId = clusterId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRemoteWritesResultToKotlin(getRemoteWritesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRemoteWrites].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;arms&#46;kotlin&#46;inputs&#46;GetRemoteWritesPlainArgs].
     * @return A collection of values returned by getRemoteWrites.
     */
    public suspend fun getRemoteWrites(argument: suspend GetRemoteWritesPlainArgsBuilder.() -> Unit): GetRemoteWritesResult {
        val builder = GetRemoteWritesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRemoteWritesResultToKotlin(getRemoteWritesPlain(builtArgument.toJava()).await())
    }
}
