@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleGroupRule
import com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleLabelMatchExpressionGrid
import com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleNotifyRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleGroupRule.Companion.toKotlin as dispatchRuleGroupRuleToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleLabelMatchExpressionGrid.Companion.toKotlin as dispatchRuleLabelMatchExpressionGridToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleNotifyRule.Companion.toKotlin as dispatchRuleNotifyRuleToKotlin

/**
 * Builder for [DispatchRule].
 */
@PulumiTagMarker
public class DispatchRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DispatchRuleArgs = DispatchRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DispatchRuleArgsBuilder.() -> Unit) {
        val builder = DispatchRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DispatchRule {
        val builtJavaResource = com.pulumi.alicloud.arms.DispatchRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DispatchRule(builtJavaResource)
    }
}

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule and how to use it, see [What is Alert Dispatch_Rule](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/CreateDispatchRule).
 * > **NOTE:** Available since v1.136.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.arms.AlertContact("default", {
 *     alertContactName: "example_value",
 *     email: "example_value@aaa.com",
 * });
 * const defaultAlertContactGroup = new alicloud.arms.AlertContactGroup("default", {
 *     alertContactGroupName: "example_value",
 *     contactIds: [_default&#46;id],
 * });
 * const defaultDispatchRule = new alicloud.arms.DispatchRule("default", {
 *     dispatchRuleName: "example_value",
 *     dispatchType: "CREATE_ALERT",
 *     groupRules: [{
 *         groupWaitTime: 5,
 *         groupInterval: 15,
 *         repeatInterval: 100,
 *         groupingFields: ["alertname"],
 *     }],
 *     labelMatchExpressionGrids: [{
 *         labelMatchExpressionGroups: [{
 *             labelMatchExpressions: [{
 *                 key: "_aliyun_arms_involvedObject_kind",
 *                 value: "app",
 *                 operator: "eq",
 *             }],
 *         }],
 *     }],
 *     notifyRules: [{
 *         notifyObjects: [
 *             {
 *                 notifyObjectId: _default.id,
 *                 notifyType: "ARMS_CONTACT",
 *                 name: "example_value",
 *             },
 *             {
 *                 notifyObjectId: defaultAlertContactGroup.id,
 *                 notifyType: "ARMS_CONTACT_GROUP",
 *                 name: "example_value",
 *             },
 *         ],
 *         notifyChannels: [
 *             "dingTalk",
 *             "wechat",
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.arms.AlertContact("default",
 *     alert_contact_name="example_value",
 *     email="example_value@aaa.com")
 * default_alert_contact_group = alicloud.arms.AlertContactGroup("default",
 *     alert_contact_group_name="example_value",
 *     contact_ids=[default&#46;id])
 * default_dispatch_rule = alicloud.arms.DispatchRule("default",
 *     dispatch_rule_name="example_value",
 *     dispatch_type="CREATE_ALERT",
 *     group_rules=[{
 *         "group_wait_time": 5,
 *         "group_interval": 15,
 *         "repeat_interval": 100,
 *         "grouping_fields": ["alertname"],
 *     }],
 *     label_match_expression_grids=[{
 *         "label_match_expression_groups": [{
 *             "label_match_expressions": [{
 *                 "key": "_aliyun_arms_involvedObject_kind",
 *                 "value": "app",
 *                 "operator": "eq",
 *             }],
 *         }],
 *     }],
 *     notify_rules=[{
 *         "notify_objects": [
 *             {
 *                 "notify_object_id": default.id,
 *                 "notify_type": "ARMS_CONTACT",
 *                 "name": "example_value",
 *             },
 *             {
 *                 "notify_object_id": default_alert_contact_group.id,
 *                 "notify_type": "ARMS_CONTACT_GROUP",
 *                 "name": "example_value",
 *             },
 *         ],
 *         "notify_channels": [
 *             "dingTalk",
 *             "wechat",
 *         ],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Arms.AlertContact("default", new()
 *     {
 *         AlertContactName = "example_value",
 *         Email = "example_value@aaa.com",
 *     });
 *     var defaultAlertContactGroup = new AliCloud.Arms.AlertContactGroup("default", new()
 *     {
 *         AlertContactGroupName = "example_value",
 *         ContactIds = new[]
 *         {
 *             @default.Id,
 *         },
 *     });
 *     var defaultDispatchRule = new AliCloud.Arms.DispatchRule("default", new()
 *     {
 *         DispatchRuleName = "example_value",
 *         DispatchType = "CREATE_ALERT",
 *         GroupRules = new[]
 *         {
 *             new AliCloud.Arms.Inputs.DispatchRuleGroupRuleArgs
 *             {
 *                 GroupWaitTime = 5,
 *                 GroupInterval = 15,
 *                 RepeatInterval = 100,
 *                 GroupingFields = new[]
 *                 {
 *                     "alertname",
 *                 },
 *             },
 *         },
 *         LabelMatchExpressionGrids = new[]
 *         {
 *             new AliCloud.Arms.Inputs.DispatchRuleLabelMatchExpressionGridArgs
 *             {
 *                 LabelMatchExpressionGroups = new[]
 *                 {
 *                     new AliCloud.Arms.Inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs
 *                     {
 *                         LabelMatchExpressions = new[]
 *                         {
 *                             new AliCloud.Arms.Inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs
 *                             {
 *                                 Key = "_aliyun_arms_involvedObject_kind",
 *                                 Value = "app",
 *                                 Operator = "eq",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         NotifyRules = new[]
 *         {
 *             new AliCloud.Arms.Inputs.DispatchRuleNotifyRuleArgs
 *             {
 *                 NotifyObjects = new[]
 *                 {
 *                     new AliCloud.Arms.Inputs.DispatchRuleNotifyRuleNotifyObjectArgs
 *                     {
 *                         NotifyObjectId = @default.Id,
 *                         NotifyType = "ARMS_CONTACT",
 *                         Name = "example_value",
 *                     },
 *                     new AliCloud.Arms.Inputs.DispatchRuleNotifyRuleNotifyObjectArgs
 *                     {
 *                         NotifyObjectId = defaultAlertContactGroup.Id,
 *                         NotifyType = "ARMS_CONTACT_GROUP",
 *                         Name = "example_value",
 *                     },
 *                 },
 *                 NotifyChannels = new[]
 *                 {
 *                     "dingTalk",
 *                     "wechat",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := arms.NewAlertContact(ctx, "default", &arms.AlertContactArgs{
 * 			AlertContactName: pulumi.String("example_value"),
 * 			Email:            pulumi.String("example_value@aaa.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlertContactGroup, err := arms.NewAlertContactGroup(ctx, "default", &arms.AlertContactGroupArgs{
 * 			AlertContactGroupName: pulumi.String("example_value"),
 * 			ContactIds: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewDispatchRule(ctx, "default", &arms.DispatchRuleArgs{
 * 			DispatchRuleName: pulumi.String("example_value"),
 * 			DispatchType:     pulumi.String("CREATE_ALERT"),
 * 			GroupRules: arms.DispatchRuleGroupRuleArray{
 * 				&arms.DispatchRuleGroupRuleArgs{
 * 					GroupWaitTime:  pulumi.Int(5),
 * 					GroupInterval:  pulumi.Int(15),
 * 					RepeatInterval: pulumi.Int(100),
 * 					GroupingFields: pulumi.StringArray{
 * 						pulumi.String("alertname"),
 * 					},
 * 				},
 * 			},
 * 			LabelMatchExpressionGrids: arms.DispatchRuleLabelMatchExpressionGridArray{
 * 				&arms.DispatchRuleLabelMatchExpressionGridArgs{
 * 					LabelMatchExpressionGroups: arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArray{
 * 						&arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs{
 * 							LabelMatchExpressions: arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArray{
 * 								&arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs{
 * 									Key:      pulumi.String("_aliyun_arms_involvedObject_kind"),
 * 									Value:    pulumi.String("app"),
 * 									Operator: pulumi.String("eq"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NotifyRules: arms.DispatchRuleNotifyRuleArray{
 * 				&arms.DispatchRuleNotifyRuleArgs{
 * 					NotifyObjects: arms.DispatchRuleNotifyRuleNotifyObjectArray{
 * 						&arms.DispatchRuleNotifyRuleNotifyObjectArgs{
 * 							NotifyObjectId: _default.ID(),
 * 							NotifyType:     pulumi.String("ARMS_CONTACT"),
 * 							Name:           pulumi.String("example_value"),
 * 						},
 * 						&arms.DispatchRuleNotifyRuleNotifyObjectArgs{
 * 							NotifyObjectId: defaultAlertContactGroup.ID(),
 * 							NotifyType:     pulumi.String("ARMS_CONTACT_GROUP"),
 * 							Name:           pulumi.String("example_value"),
 * 						},
 * 					},
 * 					NotifyChannels: pulumi.StringArray{
 * 						pulumi.String("dingTalk"),
 * 						pulumi.String("wechat"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.arms.AlertContact;
 * import com.pulumi.alicloud.arms.AlertContactArgs;
 * import com.pulumi.alicloud.arms.AlertContactGroup;
 * import com.pulumi.alicloud.arms.AlertContactGroupArgs;
 * import com.pulumi.alicloud.arms.DispatchRule;
 * import com.pulumi.alicloud.arms.DispatchRuleArgs;
 * import com.pulumi.alicloud.arms.inputs.DispatchRuleGroupRuleArgs;
 * import com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridArgs;
 * import com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AlertContact("default", AlertContactArgs.builder()
 *             .alertContactName("example_value")
 *             .email("example_value@aaa.com")
 *             .build());
 *         var defaultAlertContactGroup = new AlertContactGroup("defaultAlertContactGroup", AlertContactGroupArgs.builder()
 *             .alertContactGroupName("example_value")
 *             .contactIds(default_.id())
 *             .build());
 *         var defaultDispatchRule = new DispatchRule("defaultDispatchRule", DispatchRuleArgs.builder()
 *             .dispatchRuleName("example_value")
 *             .dispatchType("CREATE_ALERT")
 *             .groupRules(DispatchRuleGroupRuleArgs.builder()
 *                 .groupWaitTime(5)
 *                 .groupInterval(15)
 *                 .repeatInterval(100)
 *                 .groupingFields("alertname")
 *                 .build())
 *             .labelMatchExpressionGrids(DispatchRuleLabelMatchExpressionGridArgs.builder()
 *                 .labelMatchExpressionGroups(DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs.builder()
 *                     .labelMatchExpressions(DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs.builder()
 *                         .key("_aliyun_arms_involvedObject_kind")
 *                         .value("app")
 *                         .operator("eq")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .notifyRules(DispatchRuleNotifyRuleArgs.builder()
 *                 .notifyObjects(
 *                     DispatchRuleNotifyRuleNotifyObjectArgs.builder()
 *                         .notifyObjectId(default_.id())
 *                         .notifyType("ARMS_CONTACT")
 *                         .name("example_value")
 *                         .build(),
 *                     DispatchRuleNotifyRuleNotifyObjectArgs.builder()
 *                         .notifyObjectId(defaultAlertContactGroup.id())
 *                         .notifyType("ARMS_CONTACT_GROUP")
 *                         .name("example_value")
 *                         .build())
 *                 .notifyChannels(
 *                     "dingTalk",
 *                     "wechat")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:arms:AlertContact
 *     properties:
 *       alertContactName: example_value
 *       email: example_value@aaa.com
 *   defaultAlertContactGroup:
 *     type: alicloud:arms:AlertContactGroup
 *     name: default
 *     properties:
 *       alertContactGroupName: example_value
 *       contactIds:
 *         - ${default.id}
 *   defaultDispatchRule:
 *     type: alicloud:arms:DispatchRule
 *     name: default
 *     properties:
 *       dispatchRuleName: example_value
 *       dispatchType: CREATE_ALERT
 *       groupRules:
 *         - groupWaitTime: 5
 *           groupInterval: 15
 *           repeatInterval: 100
 *           groupingFields:
 *             - alertname
 *       labelMatchExpressionGrids:
 *         - labelMatchExpressionGroups:
 *             - labelMatchExpressions:
 *                 - key: _aliyun_arms_involvedObject_kind
 *                   value: app
 *                   operator: eq
 *       notifyRules:
 *         - notifyObjects:
 *             - notifyObjectId: ${default.id}
 *               notifyType: ARMS_CONTACT
 *               name: example_value
 *             - notifyObjectId: ${defaultAlertContactGroup.id}
 *               notifyType: ARMS_CONTACT_GROUP
 *               name: example_value
 *           notifyChannels:
 *             - dingTalk
 *             - wechat
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Alert Contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/dispatchRule:DispatchRule example <id>
 * ```
 */
public class DispatchRule internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.DispatchRule,
) : KotlinCustomResource(javaResource, DispatchRuleMapper) {
    /**
     * The name of the dispatch policy.
     */
    public val dispatchRuleName: Output<String>
        get() = javaResource.dispatchRuleName().applyValue({ args0 -> args0 })

    /**
     * The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
     */
    public val dispatchType: Output<String>?
        get() = javaResource.dispatchType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    public val groupRules: Output<List<DispatchRuleGroupRule>>
        get() = javaResource.groupRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dispatchRuleGroupRuleToKotlin(args0)
                })
            })
        })

    /**
     * Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
     */
    public val isRecover: Output<Boolean>?
        get() = javaResource.isRecover().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    public val labelMatchExpressionGrids: Output<List<DispatchRuleLabelMatchExpressionGrid>>
        get() = javaResource.labelMatchExpressionGrids().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dispatchRuleLabelMatchExpressionGridToKotlin(args0) })
            })
        })

    /**
     * Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    public val notifyRules: Output<List<DispatchRuleNotifyRule>>
        get() = javaResource.notifyRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dispatchRuleNotifyRuleToKotlin(args0)
                })
            })
        })

    /**
     * The resource status of Alert Dispatch Rule.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DispatchRuleMapper : ResourceMapper<DispatchRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.DispatchRule::class == javaResource::class

    override fun map(javaResource: Resource): DispatchRule = DispatchRule(
        javaResource as
            com.pulumi.alicloud.arms.DispatchRule,
    )
}

/**
 * @see [DispatchRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DispatchRule].
 */
public suspend fun dispatchRule(
    name: String,
    block: suspend DispatchRuleResourceBuilder.() -> Unit,
): DispatchRule {
    val builder = DispatchRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DispatchRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dispatchRule(name: String): DispatchRule {
    val builder = DispatchRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
