@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.DispatchRuleArgs.builder
import com.pulumi.alicloud.arms.kotlin.inputs.DispatchRuleGroupRuleArgs
import com.pulumi.alicloud.arms.kotlin.inputs.DispatchRuleGroupRuleArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.DispatchRuleLabelMatchExpressionGridArgs
import com.pulumi.alicloud.arms.kotlin.inputs.DispatchRuleLabelMatchExpressionGridArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.DispatchRuleNotifyRuleArgs
import com.pulumi.alicloud.arms.kotlin.inputs.DispatchRuleNotifyRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule and how to use it, see [What is Alert Dispatch_Rule](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/CreateDispatchRule).
 * > **NOTE:** Available since v1.136.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.arms.AlertContact("default", {
 *     alertContactName: "example_value",
 *     email: "example_value@aaa.com",
 * });
 * const defaultAlertContactGroup = new alicloud.arms.AlertContactGroup("default", {
 *     alertContactGroupName: "example_value",
 *     contactIds: [_default&#46;id],
 * });
 * const defaultDispatchRule = new alicloud.arms.DispatchRule("default", {
 *     dispatchRuleName: "example_value",
 *     dispatchType: "CREATE_ALERT",
 *     groupRules: [{
 *         groupWaitTime: 5,
 *         groupInterval: 15,
 *         repeatInterval: 100,
 *         groupingFields: ["alertname"],
 *     }],
 *     labelMatchExpressionGrids: [{
 *         labelMatchExpressionGroups: [{
 *             labelMatchExpressions: [{
 *                 key: "_aliyun_arms_involvedObject_kind",
 *                 value: "app",
 *                 operator: "eq",
 *             }],
 *         }],
 *     }],
 *     notifyRules: [{
 *         notifyObjects: [
 *             {
 *                 notifyObjectId: _default.id,
 *                 notifyType: "ARMS_CONTACT",
 *                 name: "example_value",
 *             },
 *             {
 *                 notifyObjectId: defaultAlertContactGroup.id,
 *                 notifyType: "ARMS_CONTACT_GROUP",
 *                 name: "example_value",
 *             },
 *         ],
 *         notifyChannels: [
 *             "dingTalk",
 *             "wechat",
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.arms.AlertContact("default",
 *     alert_contact_name="example_value",
 *     email="example_value@aaa.com")
 * default_alert_contact_group = alicloud.arms.AlertContactGroup("default",
 *     alert_contact_group_name="example_value",
 *     contact_ids=[default&#46;id])
 * default_dispatch_rule = alicloud.arms.DispatchRule("default",
 *     dispatch_rule_name="example_value",
 *     dispatch_type="CREATE_ALERT",
 *     group_rules=[{
 *         "group_wait_time": 5,
 *         "group_interval": 15,
 *         "repeat_interval": 100,
 *         "grouping_fields": ["alertname"],
 *     }],
 *     label_match_expression_grids=[{
 *         "label_match_expression_groups": [{
 *             "label_match_expressions": [{
 *                 "key": "_aliyun_arms_involvedObject_kind",
 *                 "value": "app",
 *                 "operator": "eq",
 *             }],
 *         }],
 *     }],
 *     notify_rules=[{
 *         "notify_objects": [
 *             {
 *                 "notify_object_id": default.id,
 *                 "notify_type": "ARMS_CONTACT",
 *                 "name": "example_value",
 *             },
 *             {
 *                 "notify_object_id": default_alert_contact_group.id,
 *                 "notify_type": "ARMS_CONTACT_GROUP",
 *                 "name": "example_value",
 *             },
 *         ],
 *         "notify_channels": [
 *             "dingTalk",
 *             "wechat",
 *         ],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Arms.AlertContact("default", new()
 *     {
 *         AlertContactName = "example_value",
 *         Email = "example_value@aaa.com",
 *     });
 *     var defaultAlertContactGroup = new AliCloud.Arms.AlertContactGroup("default", new()
 *     {
 *         AlertContactGroupName = "example_value",
 *         ContactIds = new[]
 *         {
 *             @default.Id,
 *         },
 *     });
 *     var defaultDispatchRule = new AliCloud.Arms.DispatchRule("default", new()
 *     {
 *         DispatchRuleName = "example_value",
 *         DispatchType = "CREATE_ALERT",
 *         GroupRules = new[]
 *         {
 *             new AliCloud.Arms.Inputs.DispatchRuleGroupRuleArgs
 *             {
 *                 GroupWaitTime = 5,
 *                 GroupInterval = 15,
 *                 RepeatInterval = 100,
 *                 GroupingFields = new[]
 *                 {
 *                     "alertname",
 *                 },
 *             },
 *         },
 *         LabelMatchExpressionGrids = new[]
 *         {
 *             new AliCloud.Arms.Inputs.DispatchRuleLabelMatchExpressionGridArgs
 *             {
 *                 LabelMatchExpressionGroups = new[]
 *                 {
 *                     new AliCloud.Arms.Inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs
 *                     {
 *                         LabelMatchExpressions = new[]
 *                         {
 *                             new AliCloud.Arms.Inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs
 *                             {
 *                                 Key = "_aliyun_arms_involvedObject_kind",
 *                                 Value = "app",
 *                                 Operator = "eq",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         NotifyRules = new[]
 *         {
 *             new AliCloud.Arms.Inputs.DispatchRuleNotifyRuleArgs
 *             {
 *                 NotifyObjects = new[]
 *                 {
 *                     new AliCloud.Arms.Inputs.DispatchRuleNotifyRuleNotifyObjectArgs
 *                     {
 *                         NotifyObjectId = @default.Id,
 *                         NotifyType = "ARMS_CONTACT",
 *                         Name = "example_value",
 *                     },
 *                     new AliCloud.Arms.Inputs.DispatchRuleNotifyRuleNotifyObjectArgs
 *                     {
 *                         NotifyObjectId = defaultAlertContactGroup.Id,
 *                         NotifyType = "ARMS_CONTACT_GROUP",
 *                         Name = "example_value",
 *                     },
 *                 },
 *                 NotifyChannels = new[]
 *                 {
 *                     "dingTalk",
 *                     "wechat",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := arms.NewAlertContact(ctx, "default", &arms.AlertContactArgs{
 * 			AlertContactName: pulumi.String("example_value"),
 * 			Email:            pulumi.String("example_value@aaa.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlertContactGroup, err := arms.NewAlertContactGroup(ctx, "default", &arms.AlertContactGroupArgs{
 * 			AlertContactGroupName: pulumi.String("example_value"),
 * 			ContactIds: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewDispatchRule(ctx, "default", &arms.DispatchRuleArgs{
 * 			DispatchRuleName: pulumi.String("example_value"),
 * 			DispatchType:     pulumi.String("CREATE_ALERT"),
 * 			GroupRules: arms.DispatchRuleGroupRuleArray{
 * 				&arms.DispatchRuleGroupRuleArgs{
 * 					GroupWaitTime:  pulumi.Int(5),
 * 					GroupInterval:  pulumi.Int(15),
 * 					RepeatInterval: pulumi.Int(100),
 * 					GroupingFields: pulumi.StringArray{
 * 						pulumi.String("alertname"),
 * 					},
 * 				},
 * 			},
 * 			LabelMatchExpressionGrids: arms.DispatchRuleLabelMatchExpressionGridArray{
 * 				&arms.DispatchRuleLabelMatchExpressionGridArgs{
 * 					LabelMatchExpressionGroups: arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArray{
 * 						&arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs{
 * 							LabelMatchExpressions: arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArray{
 * 								&arms.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs{
 * 									Key:      pulumi.String("_aliyun_arms_involvedObject_kind"),
 * 									Value:    pulumi.String("app"),
 * 									Operator: pulumi.String("eq"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NotifyRules: arms.DispatchRuleNotifyRuleArray{
 * 				&arms.DispatchRuleNotifyRuleArgs{
 * 					NotifyObjects: arms.DispatchRuleNotifyRuleNotifyObjectArray{
 * 						&arms.DispatchRuleNotifyRuleNotifyObjectArgs{
 * 							NotifyObjectId: _default.ID(),
 * 							NotifyType:     pulumi.String("ARMS_CONTACT"),
 * 							Name:           pulumi.String("example_value"),
 * 						},
 * 						&arms.DispatchRuleNotifyRuleNotifyObjectArgs{
 * 							NotifyObjectId: defaultAlertContactGroup.ID(),
 * 							NotifyType:     pulumi.String("ARMS_CONTACT_GROUP"),
 * 							Name:           pulumi.String("example_value"),
 * 						},
 * 					},
 * 					NotifyChannels: pulumi.StringArray{
 * 						pulumi.String("dingTalk"),
 * 						pulumi.String("wechat"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.arms.AlertContact;
 * import com.pulumi.alicloud.arms.AlertContactArgs;
 * import com.pulumi.alicloud.arms.AlertContactGroup;
 * import com.pulumi.alicloud.arms.AlertContactGroupArgs;
 * import com.pulumi.alicloud.arms.DispatchRule;
 * import com.pulumi.alicloud.arms.DispatchRuleArgs;
 * import com.pulumi.alicloud.arms.inputs.DispatchRuleGroupRuleArgs;
 * import com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridArgs;
 * import com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AlertContact("default", AlertContactArgs.builder()
 *             .alertContactName("example_value")
 *             .email("example_value@aaa.com")
 *             .build());
 *         var defaultAlertContactGroup = new AlertContactGroup("defaultAlertContactGroup", AlertContactGroupArgs.builder()
 *             .alertContactGroupName("example_value")
 *             .contactIds(default_.id())
 *             .build());
 *         var defaultDispatchRule = new DispatchRule("defaultDispatchRule", DispatchRuleArgs.builder()
 *             .dispatchRuleName("example_value")
 *             .dispatchType("CREATE_ALERT")
 *             .groupRules(DispatchRuleGroupRuleArgs.builder()
 *                 .groupWaitTime(5)
 *                 .groupInterval(15)
 *                 .repeatInterval(100)
 *                 .groupingFields("alertname")
 *                 .build())
 *             .labelMatchExpressionGrids(DispatchRuleLabelMatchExpressionGridArgs.builder()
 *                 .labelMatchExpressionGroups(DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs.builder()
 *                     .labelMatchExpressions(DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs.builder()
 *                         .key("_aliyun_arms_involvedObject_kind")
 *                         .value("app")
 *                         .operator("eq")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .notifyRules(DispatchRuleNotifyRuleArgs.builder()
 *                 .notifyObjects(
 *                     DispatchRuleNotifyRuleNotifyObjectArgs.builder()
 *                         .notifyObjectId(default_.id())
 *                         .notifyType("ARMS_CONTACT")
 *                         .name("example_value")
 *                         .build(),
 *                     DispatchRuleNotifyRuleNotifyObjectArgs.builder()
 *                         .notifyObjectId(defaultAlertContactGroup.id())
 *                         .notifyType("ARMS_CONTACT_GROUP")
 *                         .name("example_value")
 *                         .build())
 *                 .notifyChannels(
 *                     "dingTalk",
 *                     "wechat")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:arms:AlertContact
 *     properties:
 *       alertContactName: example_value
 *       email: example_value@aaa.com
 *   defaultAlertContactGroup:
 *     type: alicloud:arms:AlertContactGroup
 *     name: default
 *     properties:
 *       alertContactGroupName: example_value
 *       contactIds:
 *         - ${default.id}
 *   defaultDispatchRule:
 *     type: alicloud:arms:DispatchRule
 *     name: default
 *     properties:
 *       dispatchRuleName: example_value
 *       dispatchType: CREATE_ALERT
 *       groupRules:
 *         - groupWaitTime: 5
 *           groupInterval: 15
 *           repeatInterval: 100
 *           groupingFields:
 *             - alertname
 *       labelMatchExpressionGrids:
 *         - labelMatchExpressionGroups:
 *             - labelMatchExpressions:
 *                 - key: _aliyun_arms_involvedObject_kind
 *                   value: app
 *                   operator: eq
 *       notifyRules:
 *         - notifyObjects:
 *             - notifyObjectId: ${default.id}
 *               notifyType: ARMS_CONTACT
 *               name: example_value
 *             - notifyObjectId: ${defaultAlertContactGroup.id}
 *               notifyType: ARMS_CONTACT_GROUP
 *               name: example_value
 *           notifyChannels:
 *             - dingTalk
 *             - wechat
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Alert Contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/dispatchRule:DispatchRule example <id>
 * ```
 * @property dispatchRuleName The name of the dispatch policy.
 * @property dispatchType The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
 * @property groupRules Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
 * @property isRecover Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
 * @property labelMatchExpressionGrids Sets the dispatch rule. See `label_match_expression_grid` below.
 * @property notifyRules Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
 */
public data class DispatchRuleArgs(
    public val dispatchRuleName: Output<String>? = null,
    public val dispatchType: Output<String>? = null,
    public val groupRules: Output<List<DispatchRuleGroupRuleArgs>>? = null,
    public val isRecover: Output<Boolean>? = null,
    public val labelMatchExpressionGrids: Output<List<DispatchRuleLabelMatchExpressionGridArgs>>? =
        null,
    public val notifyRules: Output<List<DispatchRuleNotifyRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.DispatchRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.DispatchRuleArgs =
        com.pulumi.alicloud.arms.DispatchRuleArgs.builder()
            .dispatchRuleName(dispatchRuleName?.applyValue({ args0 -> args0 }))
            .dispatchType(dispatchType?.applyValue({ args0 -> args0 }))
            .groupRules(
                groupRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isRecover(isRecover?.applyValue({ args0 -> args0 }))
            .labelMatchExpressionGrids(
                labelMatchExpressionGrids?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .notifyRules(
                notifyRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DispatchRuleArgs].
 */
@PulumiTagMarker
public class DispatchRuleArgsBuilder internal constructor() {
    private var dispatchRuleName: Output<String>? = null

    private var dispatchType: Output<String>? = null

    private var groupRules: Output<List<DispatchRuleGroupRuleArgs>>? = null

    private var isRecover: Output<Boolean>? = null

    private var labelMatchExpressionGrids: Output<List<DispatchRuleLabelMatchExpressionGridArgs>>? =
        null

    private var notifyRules: Output<List<DispatchRuleNotifyRuleArgs>>? = null

    /**
     * @param value The name of the dispatch policy.
     */
    @JvmName("dpirmpqtuqhwjfsm")
    public suspend fun dispatchRuleName(`value`: Output<String>) {
        this.dispatchRuleName = value
    }

    /**
     * @param value The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
     */
    @JvmName("niorrdpldasldlpi")
    public suspend fun dispatchType(`value`: Output<String>) {
        this.dispatchType = value
    }

    /**
     * @param value Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("qaseodpdmyiwmjrp")
    public suspend fun groupRules(`value`: Output<List<DispatchRuleGroupRuleArgs>>) {
        this.groupRules = value
    }

    @JvmName("mdyjlslsmokamvuf")
    public suspend fun groupRules(vararg values: Output<DispatchRuleGroupRuleArgs>) {
        this.groupRules = Output.all(values.asList())
    }

    /**
     * @param values Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("vtgrdxrjqfkonblv")
    public suspend fun groupRules(values: List<Output<DispatchRuleGroupRuleArgs>>) {
        this.groupRules = Output.all(values)
    }

    /**
     * @param value Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
     */
    @JvmName("gifvbltxujetdumx")
    public suspend fun isRecover(`value`: Output<Boolean>) {
        this.isRecover = value
    }

    /**
     * @param value Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("jbtmejauaepbbdmo")
    public suspend fun labelMatchExpressionGrids(`value`: Output<List<DispatchRuleLabelMatchExpressionGridArgs>>) {
        this.labelMatchExpressionGrids = value
    }

    @JvmName("ymjhgvkyyswpcqqf")
    public suspend fun labelMatchExpressionGrids(vararg values: Output<DispatchRuleLabelMatchExpressionGridArgs>) {
        this.labelMatchExpressionGrids = Output.all(values.asList())
    }

    /**
     * @param values Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("uunyfhsqggfilgkq")
    public suspend fun labelMatchExpressionGrids(values: List<Output<DispatchRuleLabelMatchExpressionGridArgs>>) {
        this.labelMatchExpressionGrids = Output.all(values)
    }

    /**
     * @param value Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("uulaoydruvomyyan")
    public suspend fun notifyRules(`value`: Output<List<DispatchRuleNotifyRuleArgs>>) {
        this.notifyRules = value
    }

    @JvmName("xmsqnplvbtfattgc")
    public suspend fun notifyRules(vararg values: Output<DispatchRuleNotifyRuleArgs>) {
        this.notifyRules = Output.all(values.asList())
    }

    /**
     * @param values Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("ahpwynntslmgyans")
    public suspend fun notifyRules(values: List<Output<DispatchRuleNotifyRuleArgs>>) {
        this.notifyRules = Output.all(values)
    }

    /**
     * @param value The name of the dispatch policy.
     */
    @JvmName("djfvnetrkegxrvde")
    public suspend fun dispatchRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dispatchRuleName = mapped
    }

    /**
     * @param value The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
     */
    @JvmName("vgusuwcoxrtwgues")
    public suspend fun dispatchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dispatchType = mapped
    }

    /**
     * @param value Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("ldcuknitcvrwfenl")
    public suspend fun groupRules(`value`: List<DispatchRuleGroupRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupRules = mapped
    }

    /**
     * @param argument Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("gqimdvgcypbmlteu")
    public suspend fun groupRules(argument: List<suspend DispatchRuleGroupRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DispatchRuleGroupRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupRules = mapped
    }

    /**
     * @param argument Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("utuirqohjfvtpiob")
    public suspend fun groupRules(vararg argument: suspend DispatchRuleGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DispatchRuleGroupRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupRules = mapped
    }

    /**
     * @param argument Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("kqvkclvoogtjhwfk")
    public suspend fun groupRules(argument: suspend DispatchRuleGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DispatchRuleGroupRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groupRules = mapped
    }

    /**
     * @param values Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("srepdjvebjenobgj")
    public suspend fun groupRules(vararg values: DispatchRuleGroupRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupRules = mapped
    }

    /**
     * @param value Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
     */
    @JvmName("lvqiyegwpyydbgtr")
    public suspend fun isRecover(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRecover = mapped
    }

    /**
     * @param value Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("qoeugptegcnxokmp")
    public suspend fun labelMatchExpressionGrids(`value`: List<DispatchRuleLabelMatchExpressionGridArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelMatchExpressionGrids = mapped
    }

    /**
     * @param argument Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("ksbrkpkxknirqnui")
    public suspend fun labelMatchExpressionGrids(argument: List<suspend DispatchRuleLabelMatchExpressionGridArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DispatchRuleLabelMatchExpressionGridArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labelMatchExpressionGrids = mapped
    }

    /**
     * @param argument Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("gukerkgrttjlvghr")
    public suspend fun labelMatchExpressionGrids(vararg argument: suspend DispatchRuleLabelMatchExpressionGridArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DispatchRuleLabelMatchExpressionGridArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labelMatchExpressionGrids = mapped
    }

    /**
     * @param argument Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("oreyidalchhnhshx")
    public suspend fun labelMatchExpressionGrids(argument: suspend DispatchRuleLabelMatchExpressionGridArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DispatchRuleLabelMatchExpressionGridArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.labelMatchExpressionGrids = mapped
    }

    /**
     * @param values Sets the dispatch rule. See `label_match_expression_grid` below.
     */
    @JvmName("nayyjgoevyuyywai")
    public suspend fun labelMatchExpressionGrids(vararg values: DispatchRuleLabelMatchExpressionGridArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelMatchExpressionGrids = mapped
    }

    /**
     * @param value Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("cyfcpghellacgivi")
    public suspend fun notifyRules(`value`: List<DispatchRuleNotifyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyRules = mapped
    }

    /**
     * @param argument Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("pfaxcibrmmugpsfa")
    public suspend fun notifyRules(argument: List<suspend DispatchRuleNotifyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DispatchRuleNotifyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notifyRules = mapped
    }

    /**
     * @param argument Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("vbsyrgbreperpwrr")
    public suspend fun notifyRules(vararg argument: suspend DispatchRuleNotifyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DispatchRuleNotifyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notifyRules = mapped
    }

    /**
     * @param argument Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("eiemlcgujrcdnrun")
    public suspend fun notifyRules(argument: suspend DispatchRuleNotifyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DispatchRuleNotifyRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notifyRules = mapped
    }

    /**
     * @param values Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
     */
    @JvmName("oqhmxyosnrllxvkk")
    public suspend fun notifyRules(vararg values: DispatchRuleNotifyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyRules = mapped
    }

    internal fun build(): DispatchRuleArgs = DispatchRuleArgs(
        dispatchRuleName = dispatchRuleName,
        dispatchType = dispatchType,
        groupRules = groupRules,
        isRecover = isRecover,
        labelMatchExpressionGrids = labelMatchExpressionGrids,
        notifyRules = notifyRules,
    )
}
