@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnvCustomJob].
 */
@PulumiTagMarker
public class EnvCustomJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvCustomJobArgs = EnvCustomJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvCustomJobArgsBuilder.() -> Unit) {
        val builder = EnvCustomJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvCustomJob {
        val builtJavaResource = com.pulumi.alicloud.arms.EnvCustomJob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvCustomJob(builtJavaResource)
    }
}

/**
 * Provides a ARMS Env Custom Job resource. Custom jobs in the arms environment.
 * For information about ARMS Env Custom Job and how to use it, see [What is Env Custom Job](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvcustomjob).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     description: name,
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const env_ecs = new alicloud.arms.Environment("env-ecs", {
 *     environmentType: "ECS",
 *     environmentName: `terraform-example-${_default.result}`,
 *     bindResourceId: vpc.id,
 *     environmentSubType: "ECS",
 * });
 * const defaultEnvCustomJob = new alicloud.arms.EnvCustomJob("default", {
 *     status: "run",
 *     environmentId: env_ecs.id,
 *     envCustomJobName: name,
 *     configYaml: `scrape_configs:
 * - job_name: job-demo1
 *   honor_timestamps: false
 *   honor_labels: false
 *   scrape_interval: 30s
 *   scheme: http
 *   metrics_path: /metric
 *   static_configs:
 *   - targets:
 *     - 127.0.0.1:9090
 * `,
 *     aliyunLang: "en",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * vpc = alicloud.vpc.Network("vpc",
 *     description=name,
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * env_ecs = alicloud.arms.Environment("env-ecs",
 *     environment_type="ECS",
 *     environment_name=f"terraform-example-{default['result']}",
 *     bind_resource_id=vpc.id,
 *     environment_sub_type="ECS")
 * default_env_custom_job = alicloud.arms.EnvCustomJob("default",
 *     status="run",
 *     environment_id=env_ecs.id,
 *     env_custom_job_name=name,
 *     config_yaml="""scrape_configs:
 * - job_name: job-demo1
 *   honor_timestamps: false
 *   honor_labels: false
 *   scrape_interval: 30s
 *   scheme: http
 *   metrics_path: /metric
 *   static_configs:
 *   - targets:
 *     - 127.0.0.1:9090
 * """,
 *     aliyun_lang="en")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         Description = name,
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var env_ecs = new AliCloud.Arms.Environment("env-ecs", new()
 *     {
 *         EnvironmentType = "ECS",
 *         EnvironmentName = $"terraform-example-{@default.Result}",
 *         BindResourceId = vpc.Id,
 *         EnvironmentSubType = "ECS",
 *     });
 *     var defaultEnvCustomJob = new AliCloud.Arms.EnvCustomJob("default", new()
 *     {
 *         Status = "run",
 *         EnvironmentId = env_ecs.Id,
 *         EnvCustomJobName = name,
 *         ConfigYaml = @"scrape_configs:
 * - job_name: job-demo1
 *   honor_timestamps: false
 *   honor_labels: false
 *   scrape_interval: 30s
 *   scheme: http
 *   metrics_path: /metric
 *   static_configs:
 *   - targets:
 *     - 127.0.0.1:9090
 * ",
 *         AliyunLang = "en",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.16.0.0/12"),
 * 			VpcName:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewEnvironment(ctx, "env-ecs", &arms.EnvironmentArgs{
 * 			EnvironmentType:    pulumi.String("ECS"),
 * 			EnvironmentName:    pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			BindResourceId:     vpc.ID(),
 * 			EnvironmentSubType: pulumi.String("ECS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewEnvCustomJob(ctx, "default", &arms.EnvCustomJobArgs{
 * 			Status:           pulumi.String("run"),
 * 			EnvironmentId:    env_ecs.ID(),
 * 			EnvCustomJobName: pulumi.String(name),
 * 			ConfigYaml: pulumi.String(`scrape_configs:
 * - job_name: job-demo1
 *   honor_timestamps: false
 *   honor_labels: false
 *   scrape_interval: 30s
 *   scheme: http
 *   metrics_path: /metric
 *   static_configs:
 *   - targets:
 *     - 127.0.0.1:9090
 * `),
 * 			AliyunLang: pulumi.String("en"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.arms.Environment;
 * import com.pulumi.alicloud.arms.EnvironmentArgs;
 * import com.pulumi.alicloud.arms.EnvCustomJob;
 * import com.pulumi.alicloud.arms.EnvCustomJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         final var name = config.get("name").orElse("terraform-example");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .description(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var env_ecs = new Environment("env-ecs", EnvironmentArgs.builder()
 *             .environmentType("ECS")
 *             .environmentName(String.format("terraform-example-%s", default_.result()))
 *             .bindResourceId(vpc.id())
 *             .environmentSubType("ECS")
 *             .build());
 *         var defaultEnvCustomJob = new EnvCustomJob("defaultEnvCustomJob", EnvCustomJobArgs.builder()
 *             .status("run")
 *             .environmentId(env_ecs.id())
 *             .envCustomJobName(name)
 *             .configYaml("""
 * scrape_configs:
 * - job_name: job-demo1
 *   honor_timestamps: false
 *   honor_labels: false
 *   scrape_interval: 30s
 *   scheme: http
 *   metrics_path: /metric
 *   static_configs:
 *   - targets:
 *     - 127.0.0.1:9090
 *             """)
 *             .aliyunLang("en")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: ${name}
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   env-ecs:
 *     type: alicloud:arms:Environment
 *     properties:
 *       environmentType: ECS
 *       environmentName: terraform-example-${default.result}
 *       bindResourceId: ${vpc.id}
 *       environmentSubType: ECS
 *   defaultEnvCustomJob:
 *     type: alicloud:arms:EnvCustomJob
 *     name: default
 *     properties:
 *       status: run
 *       environmentId: ${["env-ecs"].id}
 *       envCustomJobName: ${name}
 *       configYaml: |
 *         scrape_configs:
 *         - job_name: job-demo1
 *           honor_timestamps: false
 *           honor_labels: false
 *           scrape_interval: 30s
 *           scheme: http
 *           metrics_path: /metric
 *           static_configs:
 *           - targets:
 *             - 127.0.0.1:9090
 *       aliyunLang: en
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ARMS Env Custom Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envCustomJob:EnvCustomJob example <environment_id>:<env_custom_job_name>
 * ```
 */
public class EnvCustomJob internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.EnvCustomJob,
) : KotlinCustomResource(javaResource, EnvCustomJobMapper) {
    /**
     * The locale. The default is Chinese zh | en.
     */
    public val aliyunLang: Output<String>?
        get() = javaResource.aliyunLang().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Yaml configuration string.
     */
    public val configYaml: Output<String>
        get() = javaResource.configYaml().applyValue({ args0 -> args0 })

    /**
     * Custom job name.
     */
    public val envCustomJobName: Output<String>
        get() = javaResource.envCustomJobName().applyValue({ args0 -> args0 })

    /**
     * Environment id.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Status: run, stop.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EnvCustomJobMapper : ResourceMapper<EnvCustomJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.EnvCustomJob::class == javaResource::class

    override fun map(javaResource: Resource): EnvCustomJob = EnvCustomJob(
        javaResource as
            com.pulumi.alicloud.arms.EnvCustomJob,
    )
}

/**
 * @see [EnvCustomJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvCustomJob].
 */
public suspend fun envCustomJob(
    name: String,
    block: suspend EnvCustomJobResourceBuilder.() -> Unit,
): EnvCustomJob {
    val builder = EnvCustomJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvCustomJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun envCustomJob(name: String): EnvCustomJob {
    val builder = EnvCustomJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
