@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnvFeature].
 */
@PulumiTagMarker
public class EnvFeatureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvFeatureArgs = EnvFeatureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvFeatureArgsBuilder.() -> Unit) {
        val builder = EnvFeatureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvFeature {
        val builtJavaResource = com.pulumi.alicloud.arms.EnvFeature(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvFeature(builtJavaResource)
    }
}

/**
 * Provides a ARMS Env Feature resource. Feature of the arms environment.
 * For information about ARMS Env Feature and how to use it, see [What is Env Feature](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installenvironmentfeature).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Env Feature can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envFeature:EnvFeature example <environment_id>:<env_feature_name>
 * ```
 */
public class EnvFeature internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.EnvFeature,
) : KotlinCustomResource(javaResource, EnvFeatureMapper) {
    /**
     * The name of the resource.
     */
    public val envFeatureName: Output<String>
        get() = javaResource.envFeatureName().applyValue({ args0 -> args0 })

    /**
     * The first ID of the resource.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
     */
    public val featureVersion: Output<String>
        get() = javaResource.featureVersion().applyValue({ args0 -> args0 })

    /**
     * Namespace.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * Status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EnvFeatureMapper : ResourceMapper<EnvFeature> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.EnvFeature::class == javaResource::class

    override fun map(javaResource: Resource): EnvFeature = EnvFeature(
        javaResource as
            com.pulumi.alicloud.arms.EnvFeature,
    )
}

/**
 * @see [EnvFeature].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvFeature].
 */
public suspend fun envFeature(name: String, block: suspend EnvFeatureResourceBuilder.() -> Unit): EnvFeature {
    val builder = EnvFeatureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvFeature].
 * @param name The _unique_ name of the resulting resource.
 */
public fun envFeature(name: String): EnvFeature {
    val builder = EnvFeatureResourceBuilder()
    builder.name(name)
    return builder.build()
}
