@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.EnvFeatureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Env Feature resource. Feature of the arms environment.
 * For information about ARMS Env Feature and how to use it, see [What is Env Feature](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installenvironmentfeature).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Env Feature can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envFeature:EnvFeature example <environment_id>:<env_feature_name>
 * ```
 * @property envFeatureName The name of the resource.
 * @property environmentId The first ID of the resource.
 * @property featureVersion Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
 */
public data class EnvFeatureArgs(
    public val envFeatureName: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val featureVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.EnvFeatureArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.EnvFeatureArgs =
        com.pulumi.alicloud.arms.EnvFeatureArgs.builder()
            .envFeatureName(envFeatureName?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .featureVersion(featureVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvFeatureArgs].
 */
@PulumiTagMarker
public class EnvFeatureArgsBuilder internal constructor() {
    private var envFeatureName: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var featureVersion: Output<String>? = null

    /**
     * @param value The name of the resource.
     */
    @JvmName("efpeagcddkljedsm")
    public suspend fun envFeatureName(`value`: Output<String>) {
        this.envFeatureName = value
    }

    /**
     * @param value The first ID of the resource.
     */
    @JvmName("qxonhfbvflaeghcc")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
     */
    @JvmName("vedqupcfxufpirfn")
    public suspend fun featureVersion(`value`: Output<String>) {
        this.featureVersion = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("gjulwdkojqltidfb")
    public suspend fun envFeatureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envFeatureName = mapped
    }

    /**
     * @param value The first ID of the resource.
     */
    @JvmName("dpemlfhelsqlteio")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
     */
    @JvmName("kqtcdvtmlibpnxxy")
    public suspend fun featureVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureVersion = mapped
    }

    internal fun build(): EnvFeatureArgs = EnvFeatureArgs(
        envFeatureName = envFeatureName,
        environmentId = environmentId,
        featureVersion = featureVersion,
    )
}
