@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnvPodMonitor].
 */
@PulumiTagMarker
public class EnvPodMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvPodMonitorArgs = EnvPodMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvPodMonitorArgsBuilder.() -> Unit) {
        val builder = EnvPodMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvPodMonitor {
        val builtJavaResource = com.pulumi.alicloud.arms.EnvPodMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvPodMonitor(builtJavaResource)
    }
}

/**
 * Provides a ARMS Env Pod Monitor resource. PodMonitor for the arms environment.
 * For information about ARMS Env Pod Monitor and how to use it, see [What is Env Pod Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvpodmonitor).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Env Pod Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envPodMonitor:EnvPodMonitor example <environment_id>:<namespace>:<env_pod_monitor_name>
 * ```
 */
public class EnvPodMonitor internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.EnvPodMonitor,
) : KotlinCustomResource(javaResource, EnvPodMonitorMapper) {
    /**
     * Language environment, default is Chinese zh | en.
     */
    public val aliyunLang: Output<String>?
        get() = javaResource.aliyunLang().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Yaml configuration string.
     */
    public val configYaml: Output<String>
        get() = javaResource.configYaml().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val envPodMonitorName: Output<String>
        get() = javaResource.envPodMonitorName().applyValue({ args0 -> args0 })

    /**
     * Environment id.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Resource namespace.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * PodMonitor status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EnvPodMonitorMapper : ResourceMapper<EnvPodMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.EnvPodMonitor::class == javaResource::class

    override fun map(javaResource: Resource): EnvPodMonitor = EnvPodMonitor(
        javaResource as
            com.pulumi.alicloud.arms.EnvPodMonitor,
    )
}

/**
 * @see [EnvPodMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvPodMonitor].
 */
public suspend fun envPodMonitor(
    name: String,
    block: suspend EnvPodMonitorResourceBuilder.() -> Unit,
): EnvPodMonitor {
    val builder = EnvPodMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvPodMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun envPodMonitor(name: String): EnvPodMonitor {
    val builder = EnvPodMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
