@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.EnvPodMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Env Pod Monitor resource. PodMonitor for the arms environment.
 * For information about ARMS Env Pod Monitor and how to use it, see [What is Env Pod Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvpodmonitor).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Env Pod Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envPodMonitor:EnvPodMonitor example <environment_id>:<namespace>:<env_pod_monitor_name>
 * ```
 * @property aliyunLang Language environment, default is Chinese zh | en.
 * @property configYaml Yaml configuration string.
 * @property environmentId Environment id.
 */
public data class EnvPodMonitorArgs(
    public val aliyunLang: Output<String>? = null,
    public val configYaml: Output<String>? = null,
    public val environmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.EnvPodMonitorArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.EnvPodMonitorArgs =
        com.pulumi.alicloud.arms.EnvPodMonitorArgs.builder()
            .aliyunLang(aliyunLang?.applyValue({ args0 -> args0 }))
            .configYaml(configYaml?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvPodMonitorArgs].
 */
@PulumiTagMarker
public class EnvPodMonitorArgsBuilder internal constructor() {
    private var aliyunLang: Output<String>? = null

    private var configYaml: Output<String>? = null

    private var environmentId: Output<String>? = null

    /**
     * @param value Language environment, default is Chinese zh | en.
     */
    @JvmName("gbavidhtknhhqtqe")
    public suspend fun aliyunLang(`value`: Output<String>) {
        this.aliyunLang = value
    }

    /**
     * @param value Yaml configuration string.
     */
    @JvmName("wmxvqjvyjbxsxuxv")
    public suspend fun configYaml(`value`: Output<String>) {
        this.configYaml = value
    }

    /**
     * @param value Environment id.
     */
    @JvmName("rtrxgenghkhenpni")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Language environment, default is Chinese zh | en.
     */
    @JvmName("clbxwsfancgfodxa")
    public suspend fun aliyunLang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliyunLang = mapped
    }

    /**
     * @param value Yaml configuration string.
     */
    @JvmName("puglhaipmhliafmi")
    public suspend fun configYaml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configYaml = mapped
    }

    /**
     * @param value Environment id.
     */
    @JvmName("buyinibapvwwcuri")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    internal fun build(): EnvPodMonitorArgs = EnvPodMonitorArgs(
        aliyunLang = aliyunLang,
        configYaml = configYaml,
        environmentId = environmentId,
    )
}
