@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnvServiceMonitor].
 */
@PulumiTagMarker
public class EnvServiceMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvServiceMonitorArgs = EnvServiceMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvServiceMonitorArgsBuilder.() -> Unit) {
        val builder = EnvServiceMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvServiceMonitor {
        val builtJavaResource = com.pulumi.alicloud.arms.EnvServiceMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvServiceMonitor(builtJavaResource)
    }
}

/**
 * Provides a ARMS Env Service Monitor resource. ServiceMonitor for the arms environment.
 * For information about ARMS Env Service Monitor and how to use it, see [What is Env Service Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvservicemonitor).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Env Service Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envServiceMonitor:EnvServiceMonitor example <environment_id>:<namespace>:<env_service_monitor_name>
 * ```
 */
public class EnvServiceMonitor internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.EnvServiceMonitor,
) : KotlinCustomResource(javaResource, EnvServiceMonitorMapper) {
    /**
     * Language environment, default is Chinese zh | en.
     */
    public val aliyunLang: Output<String>?
        get() = javaResource.aliyunLang().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Yaml configuration string.
     */
    public val configYaml: Output<String>
        get() = javaResource.configYaml().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val envServiceMonitorName: Output<String>
        get() = javaResource.envServiceMonitorName().applyValue({ args0 -> args0 })

    /**
     * Environment id.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * The namespace where the resource is located.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * Status: run, stop.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EnvServiceMonitorMapper : ResourceMapper<EnvServiceMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.EnvServiceMonitor::class == javaResource::class

    override fun map(javaResource: Resource): EnvServiceMonitor = EnvServiceMonitor(
        javaResource as
            com.pulumi.alicloud.arms.EnvServiceMonitor,
    )
}

/**
 * @see [EnvServiceMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvServiceMonitor].
 */
public suspend fun envServiceMonitor(
    name: String,
    block: suspend EnvServiceMonitorResourceBuilder.() -> Unit,
): EnvServiceMonitor {
    val builder = EnvServiceMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvServiceMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun envServiceMonitor(name: String): EnvServiceMonitor {
    val builder = EnvServiceMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
