@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.EnvServiceMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Env Service Monitor resource. ServiceMonitor for the arms environment.
 * For information about ARMS Env Service Monitor and how to use it, see [What is Env Service Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvservicemonitor).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Env Service Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/envServiceMonitor:EnvServiceMonitor example <environment_id>:<namespace>:<env_service_monitor_name>
 * ```
 * @property aliyunLang Language environment, default is Chinese zh | en.
 * @property configYaml Yaml configuration string.
 * @property environmentId Environment id.
 */
public data class EnvServiceMonitorArgs(
    public val aliyunLang: Output<String>? = null,
    public val configYaml: Output<String>? = null,
    public val environmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.EnvServiceMonitorArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.EnvServiceMonitorArgs =
        com.pulumi.alicloud.arms.EnvServiceMonitorArgs.builder()
            .aliyunLang(aliyunLang?.applyValue({ args0 -> args0 }))
            .configYaml(configYaml?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvServiceMonitorArgs].
 */
@PulumiTagMarker
public class EnvServiceMonitorArgsBuilder internal constructor() {
    private var aliyunLang: Output<String>? = null

    private var configYaml: Output<String>? = null

    private var environmentId: Output<String>? = null

    /**
     * @param value Language environment, default is Chinese zh | en.
     */
    @JvmName("lvuhyyxlkgtucdci")
    public suspend fun aliyunLang(`value`: Output<String>) {
        this.aliyunLang = value
    }

    /**
     * @param value Yaml configuration string.
     */
    @JvmName("puxpgepdvnxbismh")
    public suspend fun configYaml(`value`: Output<String>) {
        this.configYaml = value
    }

    /**
     * @param value Environment id.
     */
    @JvmName("xisqfgnnypxqtbpm")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Language environment, default is Chinese zh | en.
     */
    @JvmName("vabbfrnjhsasucls")
    public suspend fun aliyunLang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliyunLang = mapped
    }

    /**
     * @param value Yaml configuration string.
     */
    @JvmName("bfcgflnplqcmfkiw")
    public suspend fun configYaml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configYaml = mapped
    }

    /**
     * @param value Environment id.
     */
    @JvmName("ewqxsysctncpbsvo")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    internal fun build(): EnvServiceMonitorArgs = EnvServiceMonitorArgs(
        aliyunLang = aliyunLang,
        configYaml = configYaml,
        environmentId = environmentId,
    )
}
