@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.alicloud.arms.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Provides a ARMS Environment resource. The arms environment.
 * For information about ARMS Environment and how to use it, see [What is Environment](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvironment).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Environment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/environment:Environment example <id>
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * The locale. The default is Chinese zh | en.
     */
    public val aliyunLang: Output<String>?
        get() = javaResource.aliyunLang().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id or vpcId of the bound container instance.
     */
    public val bindResourceId: Output<String>?
        get() = javaResource.bindResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of abandoned indicators.
     */
    public val dropMetrics: Output<String>?
        get() = javaResource.dropMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The first ID of the resource.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val environmentName: Output<String>?
        get() = javaResource.environmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subtype of environment:
     * - Type of CS: ACK is currently supported.
     * - Type of ECS: currently supports ECS.
     * - Type of Cloud: currently supports Cloud.
     */
    public val environmentSubType: Output<String>
        get() = javaResource.environmentSubType().applyValue({ args0 -> args0 })

    /**
     * Type of environment.
     */
    public val environmentType: Output<String>
        get() = javaResource.environmentType().applyValue({ args0 -> args0 })

    /**
     * Hosting type:
     * - none: unmanaged. The default value of the ACK cluster.
     * - agent: Managed agent (including ksm). Default values of ASK, ACS, and Acone clusters.
     * - agent-exproter: Managed agent and exporter. The default value of the cloud service type.
     */
    public val managedType: Output<String>
        get() = javaResource.managedType().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.alicloud.arms.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
