@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.EnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Environment resource. The arms environment.
 * For information about ARMS Environment and how to use it, see [What is Environment](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvironment).
 * > **NOTE:** Available since v1.212.0.
 * ## Import
 * ARMS Environment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/environment:Environment example <id>
 * ```
 * @property aliyunLang The locale. The default is Chinese zh | en.
 * @property bindResourceId The id or vpcId of the bound container instance.
 * @property dropMetrics List of abandoned indicators.
 * @property environmentName The name of the resource.
 * @property environmentSubType Subtype of environment:
 * - Type of CS: ACK is currently supported.
 * - Type of ECS: currently supports ECS.
 * - Type of Cloud: currently supports Cloud.
 * @property environmentType Type of environment.
 * @property managedType Hosting type:
 * - none: unmanaged. The default value of the ACK cluster.
 * - agent: Managed agent (including ksm). Default values of ASK, ACS, and Acone clusters.
 * - agent-exproter: Managed agent and exporter. The default value of the cloud service type.
 * @property resourceGroupId The ID of the resource group.
 * @property tags The tag of the resource.
 */
public data class EnvironmentArgs(
    public val aliyunLang: Output<String>? = null,
    public val bindResourceId: Output<String>? = null,
    public val dropMetrics: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val environmentSubType: Output<String>? = null,
    public val environmentType: Output<String>? = null,
    public val managedType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.EnvironmentArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.EnvironmentArgs =
        com.pulumi.alicloud.arms.EnvironmentArgs.builder()
            .aliyunLang(aliyunLang?.applyValue({ args0 -> args0 }))
            .bindResourceId(bindResourceId?.applyValue({ args0 -> args0 }))
            .dropMetrics(dropMetrics?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .environmentSubType(environmentSubType?.applyValue({ args0 -> args0 }))
            .environmentType(environmentType?.applyValue({ args0 -> args0 }))
            .managedType(managedType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var aliyunLang: Output<String>? = null

    private var bindResourceId: Output<String>? = null

    private var dropMetrics: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var environmentSubType: Output<String>? = null

    private var environmentType: Output<String>? = null

    private var managedType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The locale. The default is Chinese zh | en.
     */
    @JvmName("ytrmqivpwlarvtek")
    public suspend fun aliyunLang(`value`: Output<String>) {
        this.aliyunLang = value
    }

    /**
     * @param value The id or vpcId of the bound container instance.
     */
    @JvmName("rtqvqxkqhpotlxue")
    public suspend fun bindResourceId(`value`: Output<String>) {
        this.bindResourceId = value
    }

    /**
     * @param value List of abandoned indicators.
     */
    @JvmName("cehnarpqxsvhewuo")
    public suspend fun dropMetrics(`value`: Output<String>) {
        this.dropMetrics = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("dvawrqaayhxqmaax")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Subtype of environment:
     * - Type of CS: ACK is currently supported.
     * - Type of ECS: currently supports ECS.
     * - Type of Cloud: currently supports Cloud.
     */
    @JvmName("ygdoxmoiwxornjnu")
    public suspend fun environmentSubType(`value`: Output<String>) {
        this.environmentSubType = value
    }

    /**
     * @param value Type of environment.
     */
    @JvmName("rkfojyooudwywerg")
    public suspend fun environmentType(`value`: Output<String>) {
        this.environmentType = value
    }

    /**
     * @param value Hosting type:
     * - none: unmanaged. The default value of the ACK cluster.
     * - agent: Managed agent (including ksm). Default values of ASK, ACS, and Acone clusters.
     * - agent-exproter: Managed agent and exporter. The default value of the cloud service type.
     */
    @JvmName("tflxwyboexbixpsu")
    public suspend fun managedType(`value`: Output<String>) {
        this.managedType = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ltwwpdfjfycukcry")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("bitaxwllvnymkpmr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The locale. The default is Chinese zh | en.
     */
    @JvmName("jxxfygpcpbuyjhtj")
    public suspend fun aliyunLang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliyunLang = mapped
    }

    /**
     * @param value The id or vpcId of the bound container instance.
     */
    @JvmName("voafslrhpqltlvqn")
    public suspend fun bindResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindResourceId = mapped
    }

    /**
     * @param value List of abandoned indicators.
     */
    @JvmName("awsvhdrwndriljct")
    public suspend fun dropMetrics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dropMetrics = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("sjueqgsrwyjpiunh")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Subtype of environment:
     * - Type of CS: ACK is currently supported.
     * - Type of ECS: currently supports ECS.
     * - Type of Cloud: currently supports Cloud.
     */
    @JvmName("rpuugqdoorgbcpkj")
    public suspend fun environmentSubType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentSubType = mapped
    }

    /**
     * @param value Type of environment.
     */
    @JvmName("hqatoejehmsdjhmk")
    public suspend fun environmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Hosting type:
     * - none: unmanaged. The default value of the ACK cluster.
     * - agent: Managed agent (including ksm). Default values of ASK, ACS, and Acone clusters.
     * - agent-exproter: Managed agent and exporter. The default value of the cloud service type.
     */
    @JvmName("iwddtncgmasjpqnq")
    public suspend fun managedType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedType = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("nrgnrgpkxowsuvsp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("utmmmkmfexcguxms")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("qktgssjscbvwacfv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        aliyunLang = aliyunLang,
        bindResourceId = bindResourceId,
        dropMetrics = dropMetrics,
        environmentName = environmentName,
        environmentSubType = environmentSubType,
        environmentType = environmentType,
        managedType = managedType,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
