@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GrafanaWorkspace].
 */
@PulumiTagMarker
public class GrafanaWorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GrafanaWorkspaceArgs = GrafanaWorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GrafanaWorkspaceArgsBuilder.() -> Unit) {
        val builder = GrafanaWorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GrafanaWorkspace {
        val builtJavaResource = com.pulumi.alicloud.arms.GrafanaWorkspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GrafanaWorkspace(builtJavaResource)
    }
}

/**
 * Provides a ARMS Grafana Workspace resource.
 * For information about ARMS Grafana Workspace and how to use it, see [What is Grafana Workspace](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/ListGrafanaWorkspace).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGrafanaWorkspace = new alicloud.arms.GrafanaWorkspace("default", {
 *     grafanaVersion: "9.0.x",
 *     description: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     grafanaWorkspaceEdition: "standard",
 *     grafanaWorkspaceName: name,
 *     tags: {
 *         Created: "tf",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_grafana_workspace = alicloud.arms.GrafanaWorkspace("default",
 *     grafana_version="9.0.x",
 *     description=name,
 *     resource_group_id=default.ids[0],
 *     grafana_workspace_edition="standard",
 *     grafana_workspace_name=name,
 *     tags={
 *         "Created": "tf",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGrafanaWorkspace = new AliCloud.Arms.GrafanaWorkspace("default", new()
 *     {
 *         GrafanaVersion = "9.0.x",
 *         Description = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         GrafanaWorkspaceEdition = "standard",
 *         GrafanaWorkspaceName = name,
 *         Tags =
 *         {
 *             { "Created", "tf" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewGrafanaWorkspace(ctx, "default", &arms.GrafanaWorkspaceArgs{
 * 			GrafanaVersion:          pulumi.String("9.0.x"),
 * 			Description:             pulumi.String(name),
 * 			ResourceGroupId:         pulumi.String(_default.Ids[0]),
 * 			GrafanaWorkspaceEdition: pulumi.String("standard"),
 * 			GrafanaWorkspaceName:    pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("tf"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.arms.GrafanaWorkspace;
 * import com.pulumi.alicloud.arms.GrafanaWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultGrafanaWorkspace = new GrafanaWorkspace("defaultGrafanaWorkspace", GrafanaWorkspaceArgs.builder()
 *             .grafanaVersion("9.0.x")
 *             .description(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .grafanaWorkspaceEdition("standard")
 *             .grafanaWorkspaceName(name)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "tf"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultGrafanaWorkspace:
 *     type: alicloud:arms:GrafanaWorkspace
 *     name: default
 *     properties:
 *       grafanaVersion: 9.0.x
 *       description: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       grafanaWorkspaceEdition: standard
 *       grafanaWorkspaceName: ${name}
 *       tags:
 *         Created: tf
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ARMS Grafana Workspace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/grafanaWorkspace:GrafanaWorkspace example <id>
 * ```
 */
public class GrafanaWorkspace internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.GrafanaWorkspace,
) : KotlinCustomResource(javaResource, GrafanaWorkspaceMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the grafana.
     */
    public val grafanaVersion: Output<String>?
        get() = javaResource.grafanaVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The edition of the grafana.
     */
    public val grafanaWorkspaceEdition: Output<String>?
        get() = javaResource.grafanaWorkspaceEdition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val grafanaWorkspaceName: Output<String>?
        get() = javaResource.grafanaWorkspaceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object GrafanaWorkspaceMapper : ResourceMapper<GrafanaWorkspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.GrafanaWorkspace::class == javaResource::class

    override fun map(javaResource: Resource): GrafanaWorkspace = GrafanaWorkspace(
        javaResource as
            com.pulumi.alicloud.arms.GrafanaWorkspace,
    )
}

/**
 * @see [GrafanaWorkspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GrafanaWorkspace].
 */
public suspend fun grafanaWorkspace(
    name: String,
    block: suspend GrafanaWorkspaceResourceBuilder.() -> Unit,
): GrafanaWorkspace {
    val builder = GrafanaWorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GrafanaWorkspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun grafanaWorkspace(name: String): GrafanaWorkspace {
    val builder = GrafanaWorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
