@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.GrafanaWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Grafana Workspace resource.
 * For information about ARMS Grafana Workspace and how to use it, see [What is Grafana Workspace](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/ListGrafanaWorkspace).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGrafanaWorkspace = new alicloud.arms.GrafanaWorkspace("default", {
 *     grafanaVersion: "9.0.x",
 *     description: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     grafanaWorkspaceEdition: "standard",
 *     grafanaWorkspaceName: name,
 *     tags: {
 *         Created: "tf",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_grafana_workspace = alicloud.arms.GrafanaWorkspace("default",
 *     grafana_version="9.0.x",
 *     description=name,
 *     resource_group_id=default.ids[0],
 *     grafana_workspace_edition="standard",
 *     grafana_workspace_name=name,
 *     tags={
 *         "Created": "tf",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGrafanaWorkspace = new AliCloud.Arms.GrafanaWorkspace("default", new()
 *     {
 *         GrafanaVersion = "9.0.x",
 *         Description = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         GrafanaWorkspaceEdition = "standard",
 *         GrafanaWorkspaceName = name,
 *         Tags =
 *         {
 *             { "Created", "tf" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/arms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = arms.NewGrafanaWorkspace(ctx, "default", &arms.GrafanaWorkspaceArgs{
 * 			GrafanaVersion:          pulumi.String("9.0.x"),
 * 			Description:             pulumi.String(name),
 * 			ResourceGroupId:         pulumi.String(_default.Ids[0]),
 * 			GrafanaWorkspaceEdition: pulumi.String("standard"),
 * 			GrafanaWorkspaceName:    pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("tf"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.arms.GrafanaWorkspace;
 * import com.pulumi.alicloud.arms.GrafanaWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultGrafanaWorkspace = new GrafanaWorkspace("defaultGrafanaWorkspace", GrafanaWorkspaceArgs.builder()
 *             .grafanaVersion("9.0.x")
 *             .description(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .grafanaWorkspaceEdition("standard")
 *             .grafanaWorkspaceName(name)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "tf"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultGrafanaWorkspace:
 *     type: alicloud:arms:GrafanaWorkspace
 *     name: default
 *     properties:
 *       grafanaVersion: 9.0.x
 *       description: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       grafanaWorkspaceEdition: standard
 *       grafanaWorkspaceName: ${name}
 *       tags:
 *         Created: tf
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ARMS Grafana Workspace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/grafanaWorkspace:GrafanaWorkspace example <id>
 * ```
 * @property description Description.
 * @property grafanaVersion The version of the grafana.
 * @property grafanaWorkspaceEdition The edition of the grafana.
 * @property grafanaWorkspaceName The name of the resource.
 * @property resourceGroupId The ID of the resource group.
 * @property tags The tag of the resource.
 */
public data class GrafanaWorkspaceArgs(
    public val description: Output<String>? = null,
    public val grafanaVersion: Output<String>? = null,
    public val grafanaWorkspaceEdition: Output<String>? = null,
    public val grafanaWorkspaceName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.GrafanaWorkspaceArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.GrafanaWorkspaceArgs =
        com.pulumi.alicloud.arms.GrafanaWorkspaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .grafanaVersion(grafanaVersion?.applyValue({ args0 -> args0 }))
            .grafanaWorkspaceEdition(grafanaWorkspaceEdition?.applyValue({ args0 -> args0 }))
            .grafanaWorkspaceName(grafanaWorkspaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GrafanaWorkspaceArgs].
 */
@PulumiTagMarker
public class GrafanaWorkspaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var grafanaVersion: Output<String>? = null

    private var grafanaWorkspaceEdition: Output<String>? = null

    private var grafanaWorkspaceName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description.
     */
    @JvmName("nsesqthsdoislekb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The version of the grafana.
     */
    @JvmName("syixgwrxcumasuqe")
    public suspend fun grafanaVersion(`value`: Output<String>) {
        this.grafanaVersion = value
    }

    /**
     * @param value The edition of the grafana.
     */
    @JvmName("uhojjvhiwsjyvubd")
    public suspend fun grafanaWorkspaceEdition(`value`: Output<String>) {
        this.grafanaWorkspaceEdition = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("tyifrjvxjdwiugwa")
    public suspend fun grafanaWorkspaceName(`value`: Output<String>) {
        this.grafanaWorkspaceName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("encjdidirmrywpbs")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("wfnyopfpmhucqexm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description.
     */
    @JvmName("rvqhprwoioovkfse")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The version of the grafana.
     */
    @JvmName("scbtxigvgwbtitlc")
    public suspend fun grafanaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaVersion = mapped
    }

    /**
     * @param value The edition of the grafana.
     */
    @JvmName("hogljivjvpmaddsv")
    public suspend fun grafanaWorkspaceEdition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaWorkspaceEdition = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("eratkmllebdifqse")
    public suspend fun grafanaWorkspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaWorkspaceName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vrveiwwxitmheixq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("occpiqkeashcfjlp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("bpacshkckdeisafl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GrafanaWorkspaceArgs = GrafanaWorkspaceArgs(
        description = description,
        grafanaVersion = grafanaVersion,
        grafanaWorkspaceEdition = grafanaWorkspaceEdition,
        grafanaWorkspaceName = grafanaWorkspaceName,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
