@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.kotlin.outputs.PrometheusAlertRuleAnnotation
import com.pulumi.alicloud.arms.kotlin.outputs.PrometheusAlertRuleLabel
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.arms.kotlin.outputs.PrometheusAlertRuleAnnotation.Companion.toKotlin as prometheusAlertRuleAnnotationToKotlin
import com.pulumi.alicloud.arms.kotlin.outputs.PrometheusAlertRuleLabel.Companion.toKotlin as prometheusAlertRuleLabelToKotlin

/**
 * Builder for [PrometheusAlertRule].
 */
@PulumiTagMarker
public class PrometheusAlertRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrometheusAlertRuleArgs = PrometheusAlertRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrometheusAlertRuleArgsBuilder.() -> Unit) {
        val builder = PrometheusAlertRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrometheusAlertRule {
        val builtJavaResource = com.pulumi.alicloud.arms.PrometheusAlertRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrometheusAlertRule(builtJavaResource)
    }
}

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Prometheus Alert Rule resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Prometheus Alert Rule and how to use it, see [What is Prometheus Alert Rule](https://www.alibabacloud.com/help/en/doc-detail/212056.htm).
 * > **NOTE:** Available since v1.136.0.
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Prometheus Alert Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/prometheusAlertRule:PrometheusAlertRule example <cluster_id>:<prometheus_alert_rule_id>
 * ```
 */
public class PrometheusAlertRule internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.PrometheusAlertRule,
) : KotlinCustomResource(javaResource, PrometheusAlertRuleMapper) {
    /**
     * The annotations of the alert rule. See `annotations` below.
     */
    public val annotations: Output<List<PrometheusAlertRuleAnnotation>>?
        get() = javaResource.annotations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> prometheusAlertRuleAnnotationToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ID of the cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The ID of the notification policy. This parameter is required when the `notify_type` parameter is set to `DISPATCH_RULE`.
     */
    public val dispatchRuleId: Output<String>?
        get() = javaResource.dispatchRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The duration of the alert.
     */
    public val duration: Output<String>
        get() = javaResource.duration().applyValue({ args0 -> args0 })

    /**
     * The alert rule expression that follows the PromQL syntax.
     */
    public val expression: Output<String>
        get() = javaResource.expression().applyValue({ args0 -> args0 })

    /**
     * The labels of the resource. See `labels` below.
     */
    public val labels: Output<List<PrometheusAlertRuleLabel>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> prometheusAlertRuleLabelToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The message of the alert notification.
     */
    public val message: Output<String>
        get() = javaResource.message().applyValue({ args0 -> args0 })

    /**
     * The method of sending the alert notification. Valid values: `ALERT_MANAGER`, `DISPATCH_RULE`.
     */
    public val notifyType: Output<String>?
        get() = javaResource.notifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The first ID of the resource.
     */
    public val prometheusAlertRuleId: Output<Int>
        get() = javaResource.prometheusAlertRuleId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val prometheusAlertRuleName: Output<String>
        get() = javaResource.prometheusAlertRuleName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `0`, `1`.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The type of the alert rule.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrometheusAlertRuleMapper : ResourceMapper<PrometheusAlertRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.PrometheusAlertRule::class == javaResource::class

    override fun map(javaResource: Resource): PrometheusAlertRule = PrometheusAlertRule(
        javaResource
            as com.pulumi.alicloud.arms.PrometheusAlertRule,
    )
}

/**
 * @see [PrometheusAlertRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrometheusAlertRule].
 */
public suspend fun prometheusAlertRule(
    name: String,
    block: suspend PrometheusAlertRuleResourceBuilder.() -> Unit,
): PrometheusAlertRule {
    val builder = PrometheusAlertRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrometheusAlertRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prometheusAlertRule(name: String): PrometheusAlertRule {
    val builder = PrometheusAlertRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
