@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.PrometheusAlertRuleArgs.builder
import com.pulumi.alicloud.arms.kotlin.inputs.PrometheusAlertRuleAnnotationArgs
import com.pulumi.alicloud.arms.kotlin.inputs.PrometheusAlertRuleAnnotationArgsBuilder
import com.pulumi.alicloud.arms.kotlin.inputs.PrometheusAlertRuleLabelArgs
import com.pulumi.alicloud.arms.kotlin.inputs.PrometheusAlertRuleLabelArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Application Real-Time Monitoring Service (ARMS) Prometheus Alert Rule resource.
 * For information about Application Real-Time Monitoring Service (ARMS) Prometheus Alert Rule and how to use it, see [What is Prometheus Alert Rule](https://www.alibabacloud.com/help/en/doc-detail/212056.htm).
 * > **NOTE:** Available since v1.136.0.
 * ## Import
 * Application Real-Time Monitoring Service (ARMS) Prometheus Alert Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/prometheusAlertRule:PrometheusAlertRule example <cluster_id>:<prometheus_alert_rule_id>
 * ```
 * @property annotations The annotations of the alert rule. See `annotations` below.
 * @property clusterId The ID of the cluster.
 * @property dispatchRuleId The ID of the notification policy. This parameter is required when the `notify_type` parameter is set to `DISPATCH_RULE`.
 * @property duration The duration of the alert.
 * @property expression The alert rule expression that follows the PromQL syntax.
 * @property labels The labels of the resource. See `labels` below.
 * @property message The message of the alert notification.
 * @property notifyType The method of sending the alert notification. Valid values: `ALERT_MANAGER`, `DISPATCH_RULE`.
 * @property prometheusAlertRuleName The name of the resource.
 * @property type The type of the alert rule.
 */
public data class PrometheusAlertRuleArgs(
    public val annotations: Output<List<PrometheusAlertRuleAnnotationArgs>>? = null,
    public val clusterId: Output<String>? = null,
    public val dispatchRuleId: Output<String>? = null,
    public val duration: Output<String>? = null,
    public val expression: Output<String>? = null,
    public val labels: Output<List<PrometheusAlertRuleLabelArgs>>? = null,
    public val message: Output<String>? = null,
    public val notifyType: Output<String>? = null,
    public val prometheusAlertRuleName: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.PrometheusAlertRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.PrometheusAlertRuleArgs =
        com.pulumi.alicloud.arms.PrometheusAlertRuleArgs.builder()
            .annotations(
                annotations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .dispatchRuleId(dispatchRuleId?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .expression(expression?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .message(message?.applyValue({ args0 -> args0 }))
            .notifyType(notifyType?.applyValue({ args0 -> args0 }))
            .prometheusAlertRuleName(prometheusAlertRuleName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrometheusAlertRuleArgs].
 */
@PulumiTagMarker
public class PrometheusAlertRuleArgsBuilder internal constructor() {
    private var annotations: Output<List<PrometheusAlertRuleAnnotationArgs>>? = null

    private var clusterId: Output<String>? = null

    private var dispatchRuleId: Output<String>? = null

    private var duration: Output<String>? = null

    private var expression: Output<String>? = null

    private var labels: Output<List<PrometheusAlertRuleLabelArgs>>? = null

    private var message: Output<String>? = null

    private var notifyType: Output<String>? = null

    private var prometheusAlertRuleName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("frrpnfkbdvjyefvp")
    public suspend fun annotations(`value`: Output<List<PrometheusAlertRuleAnnotationArgs>>) {
        this.annotations = value
    }

    @JvmName("qtvisodgmkwabokg")
    public suspend fun annotations(vararg values: Output<PrometheusAlertRuleAnnotationArgs>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("rcbwcdirvvphyboo")
    public suspend fun annotations(values: List<Output<PrometheusAlertRuleAnnotationArgs>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The ID of the cluster.
     */
    @JvmName("crughnuygahamebb")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The ID of the notification policy. This parameter is required when the `notify_type` parameter is set to `DISPATCH_RULE`.
     */
    @JvmName("jcosqeesdvjvbxju")
    public suspend fun dispatchRuleId(`value`: Output<String>) {
        this.dispatchRuleId = value
    }

    /**
     * @param value The duration of the alert.
     */
    @JvmName("tkxnpmwcutjvueqb")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The alert rule expression that follows the PromQL syntax.
     */
    @JvmName("wkeenehgnnojourw")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The labels of the resource. See `labels` below.
     */
    @JvmName("umvvbqrldpcmetba")
    public suspend fun labels(`value`: Output<List<PrometheusAlertRuleLabelArgs>>) {
        this.labels = value
    }

    @JvmName("ussrilhhtckwpfvy")
    public suspend fun labels(vararg values: Output<PrometheusAlertRuleLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The labels of the resource. See `labels` below.
     */
    @JvmName("wsrtpteehoadwpdn")
    public suspend fun labels(values: List<Output<PrometheusAlertRuleLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The message of the alert notification.
     */
    @JvmName("wlkleeakbdilwjek")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The method of sending the alert notification. Valid values: `ALERT_MANAGER`, `DISPATCH_RULE`.
     */
    @JvmName("rmfhqgxkwerslbjb")
    public suspend fun notifyType(`value`: Output<String>) {
        this.notifyType = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("dsxlnedcrwcaymga")
    public suspend fun prometheusAlertRuleName(`value`: Output<String>) {
        this.prometheusAlertRuleName = value
    }

    /**
     * @param value The type of the alert rule.
     */
    @JvmName("yymdduniwdkakkrb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("vtnjoqbtnwjisnwg")
    public suspend fun annotations(`value`: List<PrometheusAlertRuleAnnotationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param argument The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("gsfgqgcfkskvqqpy")
    public suspend fun annotations(argument: List<suspend PrometheusAlertRuleAnnotationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrometheusAlertRuleAnnotationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param argument The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("qriqykfbibhhcqqw")
    public suspend fun annotations(vararg argument: suspend PrometheusAlertRuleAnnotationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrometheusAlertRuleAnnotationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param argument The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("rekmwbqgqwdcxttd")
    public suspend fun annotations(argument: suspend PrometheusAlertRuleAnnotationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrometheusAlertRuleAnnotationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param values The annotations of the alert rule. See `annotations` below.
     */
    @JvmName("uxcjwpiffsuqgnhu")
    public suspend fun annotations(vararg values: PrometheusAlertRuleAnnotationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The ID of the cluster.
     */
    @JvmName("ykyvjhpndxkueqoo")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The ID of the notification policy. This parameter is required when the `notify_type` parameter is set to `DISPATCH_RULE`.
     */
    @JvmName("cevinxxobnjsknok")
    public suspend fun dispatchRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dispatchRuleId = mapped
    }

    /**
     * @param value The duration of the alert.
     */
    @JvmName("vjdwehxnbsijtbtx")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The alert rule expression that follows the PromQL syntax.
     */
    @JvmName("sacvunlggokrejxl")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The labels of the resource. See `labels` below.
     */
    @JvmName("mqnsitojesgilimx")
    public suspend fun labels(`value`: List<PrometheusAlertRuleLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument The labels of the resource. See `labels` below.
     */
    @JvmName("gitexkkewxbeeosx")
    public suspend fun labels(argument: List<suspend PrometheusAlertRuleLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrometheusAlertRuleLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels of the resource. See `labels` below.
     */
    @JvmName("uranbwoobaufdaha")
    public suspend fun labels(vararg argument: suspend PrometheusAlertRuleLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrometheusAlertRuleLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels of the resource. See `labels` below.
     */
    @JvmName("ycpjvvwxjarcykxe")
    public suspend fun labels(argument: suspend PrometheusAlertRuleLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrometheusAlertRuleLabelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values The labels of the resource. See `labels` below.
     */
    @JvmName("hoivheaepvhotjos")
    public suspend fun labels(vararg values: PrometheusAlertRuleLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The message of the alert notification.
     */
    @JvmName("pbonxjypwxumxxtt")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The method of sending the alert notification. Valid values: `ALERT_MANAGER`, `DISPATCH_RULE`.
     */
    @JvmName("hnqnijytrctqupok")
    public suspend fun notifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyType = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("quqphnlycumvkaqi")
    public suspend fun prometheusAlertRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusAlertRuleName = mapped
    }

    /**
     * @param value The type of the alert rule.
     */
    @JvmName("mquegtbmsqjfmcoa")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PrometheusAlertRuleArgs = PrometheusAlertRuleArgs(
        annotations = annotations,
        clusterId = clusterId,
        dispatchRuleId = dispatchRuleId,
        duration = duration,
        expression = expression,
        labels = labels,
        message = message,
        notifyType = notifyType,
        prometheusAlertRuleName = prometheusAlertRuleName,
        type = type,
    )
}
