@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrometheusMonitoring].
 */
@PulumiTagMarker
public class PrometheusMonitoringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrometheusMonitoringArgs = PrometheusMonitoringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrometheusMonitoringArgsBuilder.() -> Unit) {
        val builder = PrometheusMonitoringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrometheusMonitoring {
        val builtJavaResource = com.pulumi.alicloud.arms.PrometheusMonitoring(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrometheusMonitoring(builtJavaResource)
    }
}

/**
 * Provides a ARMS Prometheus Monitoring resource. Including serviceMonitor, podMonitor, customJob, probe and other four types of monitoring.
 * For information about ARMS Prometheus Monitoring and how to use it, see [What is Prometheus Monitoring](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-dir-managed-service-for-prometheus/).
 * > **NOTE:** Available since v1.209.0.
 * ## Import
 * ARMS Prometheus Monitoring can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/prometheusMonitoring:PrometheusMonitoring example <cluster_id>:<monitoring_name>:<type>
 * ```
 */
public class PrometheusMonitoring internal constructor(
    override val javaResource: com.pulumi.alicloud.arms.PrometheusMonitoring,
) : KotlinCustomResource(javaResource, PrometheusMonitoringMapper) {
    /**
     * The ID of the prometheus instance.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * Yaml configuration for monitoring.
     */
    public val configYaml: Output<String>
        get() = javaResource.configYaml().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val monitoringName: Output<String>
        get() = javaResource.monitoringName().applyValue({ args0 -> args0 })

    /**
     * Valid values: `stop`, `run`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Monitoring type: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrometheusMonitoringMapper : ResourceMapper<PrometheusMonitoring> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.arms.PrometheusMonitoring::class == javaResource::class

    override fun map(javaResource: Resource): PrometheusMonitoring = PrometheusMonitoring(
        javaResource
            as com.pulumi.alicloud.arms.PrometheusMonitoring,
    )
}

/**
 * @see [PrometheusMonitoring].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrometheusMonitoring].
 */
public suspend fun prometheusMonitoring(
    name: String,
    block: suspend PrometheusMonitoringResourceBuilder.() -> Unit,
): PrometheusMonitoring {
    val builder = PrometheusMonitoringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrometheusMonitoring].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prometheusMonitoring(name: String): PrometheusMonitoring {
    val builder = PrometheusMonitoringResourceBuilder()
    builder.name(name)
    return builder.build()
}
