@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin

import com.pulumi.alicloud.arms.PrometheusMonitoringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ARMS Prometheus Monitoring resource. Including serviceMonitor, podMonitor, customJob, probe and other four types of monitoring.
 * For information about ARMS Prometheus Monitoring and how to use it, see [What is Prometheus Monitoring](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-dir-managed-service-for-prometheus/).
 * > **NOTE:** Available since v1.209.0.
 * ## Import
 * ARMS Prometheus Monitoring can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:arms/prometheusMonitoring:PrometheusMonitoring example <cluster_id>:<monitoring_name>:<type>
 * ```
 * @property clusterId The ID of the prometheus instance.
 * @property configYaml Yaml configuration for monitoring.
 * @property status Valid values: `stop`, `run`.
 * @property type Monitoring type: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
 */
public data class PrometheusMonitoringArgs(
    public val clusterId: Output<String>? = null,
    public val configYaml: Output<String>? = null,
    public val status: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.PrometheusMonitoringArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.PrometheusMonitoringArgs =
        com.pulumi.alicloud.arms.PrometheusMonitoringArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .configYaml(configYaml?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrometheusMonitoringArgs].
 */
@PulumiTagMarker
public class PrometheusMonitoringArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var configYaml: Output<String>? = null

    private var status: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ID of the prometheus instance.
     */
    @JvmName("qaolslundtvvnowx")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Yaml configuration for monitoring.
     */
    @JvmName("khrbhfmuwkhitmwp")
    public suspend fun configYaml(`value`: Output<String>) {
        this.configYaml = value
    }

    /**
     * @param value Valid values: `stop`, `run`.
     */
    @JvmName("jnwirkmhyfbtfpvq")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Monitoring type: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
     */
    @JvmName("gfwyitvpwpogddjw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of the prometheus instance.
     */
    @JvmName("ejilnjipccbgtqmd")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Yaml configuration for monitoring.
     */
    @JvmName("rcedlvfmoidvlapk")
    public suspend fun configYaml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configYaml = mapped
    }

    /**
     * @param value Valid values: `stop`, `run`.
     */
    @JvmName("nsnoaiqxtctorldo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Monitoring type: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
     */
    @JvmName("rlisaueafmchkvmf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PrometheusMonitoringArgs = PrometheusMonitoringArgs(
        clusterId = clusterId,
        configYaml = configYaml,
        status = status,
        type = type,
    )
}
