@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.DispatchRuleGroupRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groupId The ID of the group rule.
 * @property groupInterval The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
 * @property groupWaitTime The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
 * @property groupingFields The fields that are used to group events. Events with the same field content are assigned to a group. Alerts with the same specified grouping field are sent to the handler in separate notifications.
 * @property repeatInterval The silence period of repeated alerts. All alerts are repeatedly sent at specified intervals until the alerts are cleared. The minimum value is 61. Default to 600.
 */
public data class DispatchRuleGroupRuleArgs(
    public val groupId: Output<Int>? = null,
    public val groupInterval: Output<Int>,
    public val groupWaitTime: Output<Int>,
    public val groupingFields: Output<List<String>>,
    public val repeatInterval: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.DispatchRuleGroupRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.DispatchRuleGroupRuleArgs =
        com.pulumi.alicloud.arms.inputs.DispatchRuleGroupRuleArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupInterval(groupInterval.applyValue({ args0 -> args0 }))
            .groupWaitTime(groupWaitTime.applyValue({ args0 -> args0 }))
            .groupingFields(groupingFields.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .repeatInterval(repeatInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DispatchRuleGroupRuleArgs].
 */
@PulumiTagMarker
public class DispatchRuleGroupRuleArgsBuilder internal constructor() {
    private var groupId: Output<Int>? = null

    private var groupInterval: Output<Int>? = null

    private var groupWaitTime: Output<Int>? = null

    private var groupingFields: Output<List<String>>? = null

    private var repeatInterval: Output<Int>? = null

    /**
     * @param value The ID of the group rule.
     */
    @JvmName("jeyevbehqlxlikyx")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
     */
    @JvmName("cwhrybjvuaokrihe")
    public suspend fun groupInterval(`value`: Output<Int>) {
        this.groupInterval = value
    }

    /**
     * @param value The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
     */
    @JvmName("njyisltyhfabwoeb")
    public suspend fun groupWaitTime(`value`: Output<Int>) {
        this.groupWaitTime = value
    }

    /**
     * @param value The fields that are used to group events. Events with the same field content are assigned to a group. Alerts with the same specified grouping field are sent to the handler in separate notifications.
     */
    @JvmName("lctcywubowxotfys")
    public suspend fun groupingFields(`value`: Output<List<String>>) {
        this.groupingFields = value
    }

    @JvmName("qqyeudsilfascfso")
    public suspend fun groupingFields(vararg values: Output<String>) {
        this.groupingFields = Output.all(values.asList())
    }

    /**
     * @param values The fields that are used to group events. Events with the same field content are assigned to a group. Alerts with the same specified grouping field are sent to the handler in separate notifications.
     */
    @JvmName("kfoyursnfgfblvxd")
    public suspend fun groupingFields(values: List<Output<String>>) {
        this.groupingFields = Output.all(values)
    }

    /**
     * @param value The silence period of repeated alerts. All alerts are repeatedly sent at specified intervals until the alerts are cleared. The minimum value is 61. Default to 600.
     */
    @JvmName("mjboogepndvcrqmg")
    public suspend fun repeatInterval(`value`: Output<Int>) {
        this.repeatInterval = value
    }

    /**
     * @param value The ID of the group rule.
     */
    @JvmName("pgqlbsehthbgmtvo")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
     */
    @JvmName("fgqmpjqgrtgurmsu")
    public suspend fun groupInterval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupInterval = mapped
    }

    /**
     * @param value The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
     */
    @JvmName("jjhubtqjnbruispg")
    public suspend fun groupWaitTime(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupWaitTime = mapped
    }

    /**
     * @param value The fields that are used to group events. Events with the same field content are assigned to a group. Alerts with the same specified grouping field are sent to the handler in separate notifications.
     */
    @JvmName("jfdfjkqcdpnascfh")
    public suspend fun groupingFields(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupingFields = mapped
    }

    /**
     * @param values The fields that are used to group events. Events with the same field content are assigned to a group. Alerts with the same specified grouping field are sent to the handler in separate notifications.
     */
    @JvmName("cueieugvhegwpxbv")
    public suspend fun groupingFields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupingFields = mapped
    }

    /**
     * @param value The silence period of repeated alerts. All alerts are repeatedly sent at specified intervals until the alerts are cleared. The minimum value is 61. Default to 600.
     */
    @JvmName("ihgwqhqrurobsryg")
    public suspend fun repeatInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatInterval = mapped
    }

    internal fun build(): DispatchRuleGroupRuleArgs = DispatchRuleGroupRuleArgs(
        groupId = groupId,
        groupInterval = groupInterval ?: throw PulumiNullFieldException("groupInterval"),
        groupWaitTime = groupWaitTime ?: throw PulumiNullFieldException("groupWaitTime"),
        groupingFields = groupingFields ?: throw PulumiNullFieldException("groupingFields"),
        repeatInterval = repeatInterval,
    )
}
