@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property labelMatchExpressionGroups Sets the dispatch rule. See `label_match_expression_groups` below.
 */
public data class DispatchRuleLabelMatchExpressionGridArgs(
    public val labelMatchExpressionGroups: Output<List<DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs>>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridArgs =
        com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridArgs.builder()
            .labelMatchExpressionGroups(
                labelMatchExpressionGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DispatchRuleLabelMatchExpressionGridArgs].
 */
@PulumiTagMarker
public class DispatchRuleLabelMatchExpressionGridArgsBuilder internal constructor() {
    private var labelMatchExpressionGroups:
        Output<List<DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs>>? = null

    /**
     * @param value Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("josqhndrppsblcjd")
    public suspend fun labelMatchExpressionGroups(`value`: Output<List<DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs>>) {
        this.labelMatchExpressionGroups = value
    }

    @JvmName("fecfidkwxjrvlukp")
    public suspend fun labelMatchExpressionGroups(vararg values: Output<DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs>) {
        this.labelMatchExpressionGroups = Output.all(values.asList())
    }

    /**
     * @param values Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("knfvsvucndfxolam")
    public suspend fun labelMatchExpressionGroups(values: List<Output<DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs>>) {
        this.labelMatchExpressionGroups = Output.all(values)
    }

    /**
     * @param value Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("qsfuklalmxcrader")
    public suspend fun labelMatchExpressionGroups(`value`: List<DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelMatchExpressionGroups = mapped
    }

    /**
     * @param argument Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("udjjrmxepuffsgel")
    public suspend fun labelMatchExpressionGroups(argument: List<suspend DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labelMatchExpressionGroups = mapped
    }

    /**
     * @param argument Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("meajymuedupvlvtm")
    public suspend fun labelMatchExpressionGroups(vararg argument: suspend DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labelMatchExpressionGroups = mapped
    }

    /**
     * @param argument Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("euygrfgngqnuboju")
    public suspend fun labelMatchExpressionGroups(argument: suspend DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.labelMatchExpressionGroups = mapped
    }

    /**
     * @param values Sets the dispatch rule. See `label_match_expression_groups` below.
     */
    @JvmName("xdporvfdovpaknsi")
    public suspend fun labelMatchExpressionGroups(vararg values: DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelMatchExpressionGroups = mapped
    }

    internal fun build(): DispatchRuleLabelMatchExpressionGridArgs =
        DispatchRuleLabelMatchExpressionGridArgs(
            labelMatchExpressionGroups = labelMatchExpressionGroups ?: throw
                PulumiNullFieldException("labelMatchExpressionGroups"),
        )
}
