@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key of the tag of the dispatch rule. Valid values:
 * * _aliyun_arms_userid: user ID
 * * _aliyun_arms_involvedObject_kind: type of the associated object
 * * _aliyun_arms_involvedObject_id: ID of the associated object
 * * _aliyun_arms_involvedObject_name: name of the associated object
 * * _aliyun_arms_alert_name: alert name
 * * _aliyun_arms_alert_rule_id: alert rule ID
 * * _aliyun_arms_alert_type: alert type
 * * _aliyun_arms_alert_level: alert severity
 * @property operator The operator used in the dispatch rule. Valid values:
 * * eq: equals to.
 * * re: matches a regular expression.
 * @property value The value of the tag.
 */
public data class
DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs(
    public val key: Output<String>,
    public val `operator`: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs =
        com.pulumi.alicloud.arms.inputs.DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs].
 */
@PulumiTagMarker
public class
DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgsBuilder
internal constructor() {
    private var key: Output<String>? = null

    private var `operator`: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key of the tag of the dispatch rule. Valid values:
     * * _aliyun_arms_userid: user ID
     * * _aliyun_arms_involvedObject_kind: type of the associated object
     * * _aliyun_arms_involvedObject_id: ID of the associated object
     * * _aliyun_arms_involvedObject_name: name of the associated object
     * * _aliyun_arms_alert_name: alert name
     * * _aliyun_arms_alert_rule_id: alert rule ID
     * * _aliyun_arms_alert_type: alert type
     * * _aliyun_arms_alert_level: alert severity
     */
    @JvmName("ejupdegebccqrsrh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator used in the dispatch rule. Valid values:
     * * eq: equals to.
     * * re: matches a regular expression.
     */
    @JvmName("dtiwehkkmuxrvtgx")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value The value of the tag.
     */
    @JvmName("sdyscgfwquqigufu")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key of the tag of the dispatch rule. Valid values:
     * * _aliyun_arms_userid: user ID
     * * _aliyun_arms_involvedObject_kind: type of the associated object
     * * _aliyun_arms_involvedObject_id: ID of the associated object
     * * _aliyun_arms_involvedObject_name: name of the associated object
     * * _aliyun_arms_alert_name: alert name
     * * _aliyun_arms_alert_rule_id: alert rule ID
     * * _aliyun_arms_alert_type: alert type
     * * _aliyun_arms_alert_level: alert severity
     */
    @JvmName("fybnijoxitnlnndx")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator used in the dispatch rule. Valid values:
     * * eq: equals to.
     * * re: matches a regular expression.
     */
    @JvmName("wjoljsstcfktaopw")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The value of the tag.
     */
    @JvmName("xuhfvkysksetohls")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs =
        DispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupLabelMatchExpressionArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
