@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property notifyChannels The notification method. Valid values: dingTalk, sms, webhook, email, and wechat.
 * @property notifyObjects Sets the notification object. See `notify_objects` below.
 */
public data class DispatchRuleNotifyRuleArgs(
    public val notifyChannels: Output<List<String>>,
    public val notifyObjects: Output<List<DispatchRuleNotifyRuleNotifyObjectArgs>>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleArgs =
        com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleArgs.builder()
            .notifyChannels(notifyChannels.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notifyObjects(
                notifyObjects.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DispatchRuleNotifyRuleArgs].
 */
@PulumiTagMarker
public class DispatchRuleNotifyRuleArgsBuilder internal constructor() {
    private var notifyChannels: Output<List<String>>? = null

    private var notifyObjects: Output<List<DispatchRuleNotifyRuleNotifyObjectArgs>>? = null

    /**
     * @param value The notification method. Valid values: dingTalk, sms, webhook, email, and wechat.
     */
    @JvmName("dudhouhwgdivfpmb")
    public suspend fun notifyChannels(`value`: Output<List<String>>) {
        this.notifyChannels = value
    }

    @JvmName("bkfeytgpkacjwkbi")
    public suspend fun notifyChannels(vararg values: Output<String>) {
        this.notifyChannels = Output.all(values.asList())
    }

    /**
     * @param values The notification method. Valid values: dingTalk, sms, webhook, email, and wechat.
     */
    @JvmName("ryjyiibdemnqjswp")
    public suspend fun notifyChannels(values: List<Output<String>>) {
        this.notifyChannels = Output.all(values)
    }

    /**
     * @param value Sets the notification object. See `notify_objects` below.
     */
    @JvmName("wybaiaiooaudamxc")
    public suspend fun notifyObjects(`value`: Output<List<DispatchRuleNotifyRuleNotifyObjectArgs>>) {
        this.notifyObjects = value
    }

    @JvmName("cjqdubdthlanlfhu")
    public suspend fun notifyObjects(vararg values: Output<DispatchRuleNotifyRuleNotifyObjectArgs>) {
        this.notifyObjects = Output.all(values.asList())
    }

    /**
     * @param values Sets the notification object. See `notify_objects` below.
     */
    @JvmName("qtbopatcwmttodws")
    public suspend fun notifyObjects(values: List<Output<DispatchRuleNotifyRuleNotifyObjectArgs>>) {
        this.notifyObjects = Output.all(values)
    }

    /**
     * @param value The notification method. Valid values: dingTalk, sms, webhook, email, and wechat.
     */
    @JvmName("onnmfacytqyqvqqj")
    public suspend fun notifyChannels(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyChannels = mapped
    }

    /**
     * @param values The notification method. Valid values: dingTalk, sms, webhook, email, and wechat.
     */
    @JvmName("ucdeupeyhomybiiq")
    public suspend fun notifyChannels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyChannels = mapped
    }

    /**
     * @param value Sets the notification object. See `notify_objects` below.
     */
    @JvmName("bloxnykmhkyeigbv")
    public suspend fun notifyObjects(`value`: List<DispatchRuleNotifyRuleNotifyObjectArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyObjects = mapped
    }

    /**
     * @param argument Sets the notification object. See `notify_objects` below.
     */
    @JvmName("fwdcridbkrwjksio")
    public suspend fun notifyObjects(argument: List<suspend DispatchRuleNotifyRuleNotifyObjectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DispatchRuleNotifyRuleNotifyObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.notifyObjects = mapped
    }

    /**
     * @param argument Sets the notification object. See `notify_objects` below.
     */
    @JvmName("iolmbramjsmljryt")
    public suspend fun notifyObjects(vararg argument: suspend DispatchRuleNotifyRuleNotifyObjectArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DispatchRuleNotifyRuleNotifyObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.notifyObjects = mapped
    }

    /**
     * @param argument Sets the notification object. See `notify_objects` below.
     */
    @JvmName("swfeqkiirsoapkpe")
    public suspend fun notifyObjects(argument: suspend DispatchRuleNotifyRuleNotifyObjectArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DispatchRuleNotifyRuleNotifyObjectArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.notifyObjects = mapped
    }

    /**
     * @param values Sets the notification object. See `notify_objects` below.
     */
    @JvmName("fmplwkiyvotsibfn")
    public suspend fun notifyObjects(vararg values: DispatchRuleNotifyRuleNotifyObjectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyObjects = mapped
    }

    internal fun build(): DispatchRuleNotifyRuleArgs = DispatchRuleNotifyRuleArgs(
        notifyChannels = notifyChannels ?: throw PulumiNullFieldException("notifyChannels"),
        notifyObjects = notifyObjects ?: throw PulumiNullFieldException("notifyObjects"),
    )
}
