@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleNotifyObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the contact or contact group.
 * @property notifyObjectId The ID of the contact or contact group.
 * @property notifyType The type of the alert contact. Valid values: ARMS_CONTACT: contact. ARMS_CONTACT_GROUP: contact group.
 */
public data class DispatchRuleNotifyRuleNotifyObjectArgs(
    public val name: Output<String>,
    public val notifyObjectId: Output<String>,
    public val notifyType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleNotifyObjectArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleNotifyObjectArgs =
        com.pulumi.alicloud.arms.inputs.DispatchRuleNotifyRuleNotifyObjectArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .notifyObjectId(notifyObjectId.applyValue({ args0 -> args0 }))
            .notifyType(notifyType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DispatchRuleNotifyRuleNotifyObjectArgs].
 */
@PulumiTagMarker
public class DispatchRuleNotifyRuleNotifyObjectArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var notifyObjectId: Output<String>? = null

    private var notifyType: Output<String>? = null

    /**
     * @param value The name of the contact or contact group.
     */
    @JvmName("ssethmyvwidosixj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the contact or contact group.
     */
    @JvmName("goirxxcitqiooljl")
    public suspend fun notifyObjectId(`value`: Output<String>) {
        this.notifyObjectId = value
    }

    /**
     * @param value The type of the alert contact. Valid values: ARMS_CONTACT: contact. ARMS_CONTACT_GROUP: contact group.
     */
    @JvmName("hprqshubfeahhqkf")
    public suspend fun notifyType(`value`: Output<String>) {
        this.notifyType = value
    }

    /**
     * @param value The name of the contact or contact group.
     */
    @JvmName("eytehunrogadikvp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the contact or contact group.
     */
    @JvmName("aqliljfinixqiwbo")
    public suspend fun notifyObjectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyObjectId = mapped
    }

    /**
     * @param value The type of the alert contact. Valid values: ARMS_CONTACT: contact. ARMS_CONTACT_GROUP: contact group.
     */
    @JvmName("ojmyitvpehmanhfy")
    public suspend fun notifyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyType = mapped
    }

    internal fun build(): DispatchRuleNotifyRuleNotifyObjectArgs =
        DispatchRuleNotifyRuleNotifyObjectArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            notifyObjectId = notifyObjectId ?: throw PulumiNullFieldException("notifyObjectId"),
            notifyType = notifyType ?: throw PulumiNullFieldException("notifyType"),
        )
}
