@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetAlertContactGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlertContactGroups.
 * @property alertContactGroupName The name of the resource.
 * @property contactId The contact id.
 * @property contactName The contact name.
 * @property ids A list of Alert Contact Group IDs.
 * @property nameRegex A regex string to filter results by Alert Contact Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAlertContactGroupsPlainArgs(
    public val alertContactGroupName: String? = null,
    public val contactId: String? = null,
    public val contactName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetAlertContactGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetAlertContactGroupsPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetAlertContactGroupsPlainArgs.builder()
            .alertContactGroupName(alertContactGroupName?.let({ args0 -> args0 }))
            .contactId(contactId?.let({ args0 -> args0 }))
            .contactName(contactName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlertContactGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetAlertContactGroupsPlainArgsBuilder internal constructor() {
    private var alertContactGroupName: String? = null

    private var contactId: String? = null

    private var contactName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the resource.
     */
    @JvmName("nlhcrxkpbqelwsma")
    public suspend fun alertContactGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.alertContactGroupName = mapped
    }

    /**
     * @param value The contact id.
     */
    @JvmName("lmdtefwpxondtbsc")
    public suspend fun contactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contactId = mapped
    }

    /**
     * @param value The contact name.
     */
    @JvmName("ixnvwwexxalsjbtd")
    public suspend fun contactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contactName = mapped
    }

    /**
     * @param value A list of Alert Contact Group IDs.
     */
    @JvmName("yqrpwerxykiuknbp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Alert Contact Group IDs.
     */
    @JvmName("nfeegkaevvhubajy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Alert Contact Group name.
     */
    @JvmName("yyatpyppbqncgbrk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ftdehurqfkhfanrg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAlertContactGroupsPlainArgs = GetAlertContactGroupsPlainArgs(
        alertContactGroupName = alertContactGroupName,
        contactId = contactId,
        contactName = contactName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
