@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetAlertContactsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlertContacts.
 * @property alertContactName The name of the alert contact.
 * @property email The email address of the alert contact.
 * @property ids A list of Alert Contact IDs.
 * @property nameRegex A regex string to filter results by Alert Contact name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property phoneNum The mobile number of the alert contact.
 */
public data class GetAlertContactsPlainArgs(
    public val alertContactName: String? = null,
    public val email: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val phoneNum: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetAlertContactsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetAlertContactsPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetAlertContactsPlainArgs.builder()
            .alertContactName(alertContactName?.let({ args0 -> args0 }))
            .email(email?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .phoneNum(phoneNum?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlertContactsPlainArgs].
 */
@PulumiTagMarker
public class GetAlertContactsPlainArgsBuilder internal constructor() {
    private var alertContactName: String? = null

    private var email: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var phoneNum: String? = null

    /**
     * @param value The name of the alert contact.
     */
    @JvmName("xxdmihbdumdpggnl")
    public suspend fun alertContactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.alertContactName = mapped
    }

    /**
     * @param value The email address of the alert contact.
     */
    @JvmName("lsfcvwoixwlpfsgg")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.email = mapped
    }

    /**
     * @param value A list of Alert Contact IDs.
     */
    @JvmName("xvhvtmdogmxyngkf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Alert Contact IDs.
     */
    @JvmName("yerlgxptmtwqhsii")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Alert Contact name.
     */
    @JvmName("yruqlkywtnranqsw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("cufjcbevdffpdsnl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The mobile number of the alert contact.
     */
    @JvmName("ggaswipjnihwrfyg")
    public suspend fun phoneNum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.phoneNum = mapped
    }

    internal fun build(): GetAlertContactsPlainArgs = GetAlertContactsPlainArgs(
        alertContactName = alertContactName,
        email = email,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        phoneNum = phoneNum,
    )
}
