@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetDispatchRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDispatchRules.
 * @property dispatchRuleName The name of the dispatch rule.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of dispatch rule id.
 * @property nameRegex A regex string to filter results by Dispatch Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetDispatchRulesPlainArgs(
    public val dispatchRuleName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetDispatchRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetDispatchRulesPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetDispatchRulesPlainArgs.builder()
            .dispatchRuleName(dispatchRuleName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDispatchRulesPlainArgs].
 */
@PulumiTagMarker
public class GetDispatchRulesPlainArgsBuilder internal constructor() {
    private var dispatchRuleName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the dispatch rule.
     */
    @JvmName("hmcibrngkiuyhmqh")
    public suspend fun dispatchRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dispatchRuleName = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("ijsjctkqtjxuhoan")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of dispatch rule id.
     */
    @JvmName("iuublfmdrtlslvit")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of dispatch rule id.
     */
    @JvmName("pxwyyxhpoxxmbill")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Dispatch Rule name.
     */
    @JvmName("bmlqehcwwwwwsifk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lvcjmwxakyjgfsqy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDispatchRulesPlainArgs = GetDispatchRulesPlainArgs(
        dispatchRuleName = dispatchRuleName,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
