@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetIntegrationExportersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIntegrationExporters.
 * @property clusterId The ID of the Prometheus instance.
 * @property ids A list of Integration Exporter IDs.
 * @property integrationType The type of prometheus integration.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetIntegrationExportersPlainArgs(
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val integrationType: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetIntegrationExportersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetIntegrationExportersPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetIntegrationExportersPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .integrationType(integrationType.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationExportersPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationExportersPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var integrationType: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the Prometheus instance.
     */
    @JvmName("hifinhoridwfcsik")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Integration Exporter IDs.
     */
    @JvmName("xmaeehtruenuefrv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Integration Exporter IDs.
     */
    @JvmName("gdtxrpeqdftvaeue")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The type of prometheus integration.
     */
    @JvmName("umuedglqghjftjdp")
    public suspend fun integrationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("djchemvofoxnkoae")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetIntegrationExportersPlainArgs = GetIntegrationExportersPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        integrationType = integrationType ?: throw PulumiNullFieldException("integrationType"),
        outputFile = outputFile,
    )
}
