@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetPrometheusAlertRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrometheusAlertRules.
 * @property clusterId The ID of the cluster.
 * @property ids A list of Prometheus Alert Rule IDs.
 * @property matchExpressions
 * @property nameRegex A regex string to filter results by Prometheus Alert Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `0`, `1`.
 * @property type The type of the alert rule.
 */
public data class GetPrometheusAlertRulesPlainArgs(
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val matchExpressions: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetPrometheusAlertRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetPrometheusAlertRulesPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetPrometheusAlertRulesPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchExpressions(matchExpressions?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrometheusAlertRulesPlainArgs].
 */
@PulumiTagMarker
public class GetPrometheusAlertRulesPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var matchExpressions: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: Int? = null

    private var type: String? = null

    /**
     * @param value The ID of the cluster.
     */
    @JvmName("rlxqlovgjbuxhkho")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Prometheus Alert Rule IDs.
     */
    @JvmName("unkrmkmqpeawquvt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Prometheus Alert Rule IDs.
     */
    @JvmName("welwqhskfwjmbyfi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("yfnfwxpkgqnhylcq")
    public suspend fun matchExpressions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.matchExpressions = mapped
    }

    /**
     * @param value A regex string to filter results by Prometheus Alert Rule name.
     */
    @JvmName("rjfqofbjpeamwlqy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("accfgblqjaapojlw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `0`, `1`.
     */
    @JvmName("yxxdyvglinvsgfai")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The type of the alert rule.
     */
    @JvmName("fntgqaisngyesowp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetPrometheusAlertRulesPlainArgs = GetPrometheusAlertRulesPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        matchExpressions = matchExpressions,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        type = type,
    )
}
