@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetPrometheusMonitoringsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrometheusMonitorings.
 * @property clusterId The ID of the Prometheus instance.
 * @property ids A list of Prometheus Monitoring IDs.
 * @property nameRegex A regex string to filter results by Prometheus Monitoring name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the monitoring configuration. Valid values: `run`, `stop`.
 * @property type The type of the monitoring configuration. Valid values: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
 */
public data class GetPrometheusMonitoringsPlainArgs(
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetPrometheusMonitoringsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetPrometheusMonitoringsPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetPrometheusMonitoringsPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrometheusMonitoringsPlainArgs].
 */
@PulumiTagMarker
public class GetPrometheusMonitoringsPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var type: String? = null

    /**
     * @param value The ID of the Prometheus instance.
     */
    @JvmName("istcukeubukrevhb")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Prometheus Monitoring IDs.
     */
    @JvmName("jmfllhpbwquycgxg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Prometheus Monitoring IDs.
     */
    @JvmName("wqdkumhfpvwhojom")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Prometheus Monitoring name.
     */
    @JvmName("sbyaxcjdceauirva")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ctaloifddjrjwled")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the monitoring configuration. Valid values: `run`, `stop`.
     */
    @JvmName("etyudylpfymooejv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The type of the monitoring configuration. Valid values: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
     */
    @JvmName("xobrnesdheljfeyq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetPrometheusMonitoringsPlainArgs = GetPrometheusMonitoringsPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        type = type,
    )
}
