@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.GetRemoteWritesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRemoteWrites.
 * @property clusterId The ID of the Prometheus instance.
 * @property ids A list of Remote Write IDs.
 * @property nameRegex A regex string to filter results by Remote Write name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRemoteWritesPlainArgs(
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.GetRemoteWritesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.GetRemoteWritesPlainArgs =
        com.pulumi.alicloud.arms.inputs.GetRemoteWritesPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRemoteWritesPlainArgs].
 */
@PulumiTagMarker
public class GetRemoteWritesPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the Prometheus instance.
     */
    @JvmName("yyjgwgoxbujvoemv")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Remote Write IDs.
     */
    @JvmName("oegawsxkbnajqmuc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Remote Write IDs.
     */
    @JvmName("lxojgwxcxjdyyhdu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Remote Write name.
     */
    @JvmName("vqvdwdiyfhhfckap")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("baayqibnchdbkaqi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRemoteWritesPlainArgs = GetRemoteWritesPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
