@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleAnnotationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the annotation.
 * @property value The value of the annotation.
 */
public data class PrometheusAlertRuleAnnotationArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleAnnotationArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleAnnotationArgs =
        com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleAnnotationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrometheusAlertRuleAnnotationArgs].
 */
@PulumiTagMarker
public class PrometheusAlertRuleAnnotationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the annotation.
     */
    @JvmName("wtlwxhgmojvpypiu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the annotation.
     */
    @JvmName("ddgayfgqnoipjnts")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the annotation.
     */
    @JvmName("ksioputcdypqlfyn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the annotation.
     */
    @JvmName("ptsidmsbtuqrswpb")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PrometheusAlertRuleAnnotationArgs = PrometheusAlertRuleAnnotationArgs(
        name = name,
        `value` = `value`,
    )
}
